/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.LocatedStripedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.util.StripedBlockUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public abstract class ReadStripedFileWithDecodingHelper {
    static final Logger LOG = LoggerFactory.getLogger(ReadStripedFileWithDecodingHelper.class);
    protected static final ErasureCodingPolicy EC_POLICY;
    protected static final short NUM_DATA_UNITS;
    protected static final short NUM_PARITY_UNITS;
    protected static final int CELL_SIZE;
    private static final int STRIPES_PER_BLOCK = 4;
    protected static final int BLOCK_SIZE;
    private static final int BLOCK_GROUP_SIZE;
    private static final int NUM_DATANODES;
    protected static final int[] FILE_LENGTHS;

    public static MiniDFSCluster initializeCluster() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blocksize", (long)BLOCK_SIZE);
        conf.setInt("dfs.namenode.replication.max-streams", 0);
        conf.setInt("dfs.namenode.replication.max-streams-hard-limit", 0);
        conf.setBoolean("dfs.namenode.redundancy.considerLoad", false);
        MiniDFSCluster myCluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(NUM_DATANODES).build();
        myCluster.getFileSystem().enableErasureCodingPolicy(StripedFileTestUtil.getDefaultECPolicy().getName());
        myCluster.getFileSystem().getClient().setErasureCodingPolicy("/", StripedFileTestUtil.getDefaultECPolicy().getName());
        return myCluster;
    }

    public static void tearDownCluster(MiniDFSCluster cluster) throws IOException {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    public static int findFirstDataNode(MiniDFSCluster cluster, DistributedFileSystem dfs, Path file, long length) throws IOException {
        BlockLocation[] locs = dfs.getFileBlockLocations(file, 0L, length);
        String name = locs[0].getNames()[0];
        int dnIndex = 0;
        for (DataNode dn : cluster.getDataNodes()) {
            int port = dn.getXferPort();
            if (name.contains(Integer.toString(port))) {
                return dnIndex;
            }
            ++dnIndex;
        }
        return -1;
    }

    public static Collection<Object[]> getParameters() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (int fileLength : FILE_LENGTHS) {
            for (int dataDelNum = 1; dataDelNum <= NUM_PARITY_UNITS; ++dataDelNum) {
                int parityDelNum = 0;
                while (dataDelNum + parityDelNum <= NUM_PARITY_UNITS) {
                    params.add(new Object[]{fileLength, dataDelNum, parityDelNum});
                    ++parityDelNum;
                }
            }
        }
        return params;
    }

    public static void verifyRead(DistributedFileSystem dfs, Path testPath, int length, byte[] expected) throws IOException {
        LOG.info("verifyRead on path {}", (Object)testPath);
        byte[] buffer = new byte[length + 100];
        LOG.info("verifyRead verifyLength on path {}", (Object)testPath);
        StripedFileTestUtil.verifyLength((FileSystem)dfs, testPath, length);
        LOG.info("verifyRead verifyPread on path {}", (Object)testPath);
        StripedFileTestUtil.verifyPread(dfs, testPath, length, expected, buffer);
        LOG.info("verifyRead verifyStatefulRead on path {}", (Object)testPath);
        StripedFileTestUtil.verifyStatefulRead((FileSystem)dfs, testPath, length, expected, buffer);
        LOG.info("verifyRead verifyStatefulRead2 on path {}", (Object)testPath);
        StripedFileTestUtil.verifyStatefulRead((FileSystem)dfs, testPath, length, expected, ByteBuffer.allocate(length + 100));
        LOG.info("verifyRead verifySeek on path {}", (Object)testPath);
        StripedFileTestUtil.verifySeek((FileSystem)dfs, testPath, length, EC_POLICY, BLOCK_GROUP_SIZE);
    }

    public static void testReadWithDNFailure(MiniDFSCluster cluster, DistributedFileSystem dfs, int fileLength, int dnFailureNum) throws Exception {
        String fileType2 = fileLength < BLOCK_SIZE * NUM_DATA_UNITS ? "smallFile" : "largeFile";
        String src = "/dnFailure_" + dnFailureNum + "_" + fileType2;
        LOG.info("testReadWithDNFailure: file = " + src + ", fileSize = " + fileLength + ", dnFailureNum = " + dnFailureNum);
        Path testPath = new Path(src);
        byte[] bytes = StripedFileTestUtil.generateBytes(fileLength);
        DFSTestUtil.writeFile((FileSystem)dfs, testPath, bytes);
        StripedFileTestUtil.waitBlockGroupsReported(dfs, src);
        BlockLocation[] locs = dfs.getFileBlockLocations(testPath, (long)(CELL_SIZE * 5), (long)CELL_SIZE);
        for (int failedDnIdx = 0; failedDnIdx < dnFailureNum; ++failedDnIdx) {
            String name = locs[0].getNames()[failedDnIdx];
            for (DataNode dn : cluster.getDataNodes()) {
                int port = dn.getXferPort();
                if (!name.contains(Integer.toString(port))) continue;
                dn.shutdown();
            }
        }
        ReadStripedFileWithDecodingHelper.verifyRead(dfs, testPath, fileLength, bytes);
    }

    public static void testReadWithBlockCorrupted(MiniDFSCluster cluster, DistributedFileSystem dfs, String src, int fileNumBytes, int dataBlkDelNum, int parityBlkDelNum, boolean deleteBlockFile) throws IOException {
        LOG.info("testReadWithBlockCorrupted: file = " + src + ", dataBlkDelNum = " + dataBlkDelNum + ", parityBlkDelNum = " + parityBlkDelNum + ", deleteBlockFile? " + deleteBlockFile);
        int recoverBlkNum = dataBlkDelNum + parityBlkDelNum;
        Assert.assertTrue((String)"dataBlkDelNum and parityBlkDelNum should be positive", (dataBlkDelNum >= 0 && parityBlkDelNum >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("The sum of dataBlkDelNum and parityBlkDelNum should be between 1 ~ " + NUM_PARITY_UNITS), (recoverBlkNum <= NUM_PARITY_UNITS ? 1 : 0) != 0);
        Path srcPath = new Path(src);
        byte[] bytes = StripedFileTestUtil.generateBytes(fileNumBytes);
        DFSTestUtil.writeFile((FileSystem)dfs, srcPath, bytes);
        ReadStripedFileWithDecodingHelper.corruptBlocks(cluster, dfs, srcPath, dataBlkDelNum, parityBlkDelNum, deleteBlockFile);
        ReadStripedFileWithDecodingHelper.verifyRead(dfs, srcPath, fileNumBytes, bytes);
    }

    public static void corruptBlocks(MiniDFSCluster cluster, DistributedFileSystem dfs, Path srcPath, int dataBlkDelNum, int parityBlkDelNum, boolean deleteBlockFile) throws IOException {
        LOG.info("corruptBlocks on path {}", (Object)srcPath);
        int recoverBlkNum = dataBlkDelNum + parityBlkDelNum;
        LocatedBlocks locatedBlocks = ReadStripedFileWithDecodingHelper.getLocatedBlocks(dfs, srcPath);
        LocatedStripedBlock lastBlock = (LocatedStripedBlock)locatedBlocks.getLastLocatedBlock();
        int[] delDataBlkIndices = StripedFileTestUtil.randomArray(0, NUM_DATA_UNITS, dataBlkDelNum);
        Assert.assertNotNull((Object)delDataBlkIndices);
        int[] delParityBlkIndices = StripedFileTestUtil.randomArray(NUM_DATA_UNITS, NUM_DATA_UNITS + NUM_PARITY_UNITS, parityBlkDelNum);
        Assert.assertNotNull((Object)delParityBlkIndices);
        int[] delBlkIndices = new int[recoverBlkNum];
        System.arraycopy(delDataBlkIndices, 0, delBlkIndices, 0, delDataBlkIndices.length);
        System.arraycopy(delParityBlkIndices, 0, delBlkIndices, delDataBlkIndices.length, delParityBlkIndices.length);
        ExtendedBlock[] delBlocks = new ExtendedBlock[recoverBlkNum];
        for (int i = 0; i < recoverBlkNum; ++i) {
            delBlocks[i] = StripedBlockUtil.constructInternalBlock((ExtendedBlock)lastBlock.getBlock(), (int)CELL_SIZE, (int)NUM_DATA_UNITS, (int)delBlkIndices[i]);
            if (deleteBlockFile) {
                LOG.info("Deleting block file {}", (Object)delBlocks[i]);
                cluster.corruptBlockOnDataNodesByDeletingBlockFile(delBlocks[i]);
                continue;
            }
            LOG.info("Corrupting block file {}", (Object)delBlocks[i]);
            cluster.corruptBlockOnDataNodes(delBlocks[i]);
        }
    }

    public static LocatedBlocks getLocatedBlocks(DistributedFileSystem dfs, Path filePath) throws IOException {
        return dfs.getClient().getLocatedBlocks(filePath.toString(), 0L, Long.MAX_VALUE);
    }

    static {
        GenericTestUtils.setLogLevel(BlockPlacementPolicy.LOG, Level.DEBUG);
        GenericTestUtils.setLogLevel(BlockManager.LOG, Level.DEBUG);
        GenericTestUtils.setLogLevel(BlockManager.blockLog, Level.DEBUG);
        GenericTestUtils.setLogLevel(NameNode.stateChangeLog, Level.DEBUG);
        EC_POLICY = StripedFileTestUtil.getDefaultECPolicy();
        NUM_DATA_UNITS = (short)EC_POLICY.getNumDataUnits();
        NUM_PARITY_UNITS = (short)EC_POLICY.getNumParityUnits();
        CELL_SIZE = EC_POLICY.getCellSize();
        BLOCK_SIZE = CELL_SIZE * 4;
        BLOCK_GROUP_SIZE = BLOCK_SIZE * NUM_DATA_UNITS;
        NUM_DATANODES = NUM_DATA_UNITS + NUM_PARITY_UNITS;
        FILE_LENGTHS = new int[]{BLOCK_GROUP_SIZE - 123, BLOCK_GROUP_SIZE + 123};
    }
}

