/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileContextTestHelper;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.event.Level;

public abstract class FileContextCreateMkdirBaseTest {
    protected final FileContextTestHelper fileContextTestHelper = this.createFileContextHelper();
    protected static FileContext fc;

    protected FileContextTestHelper createFileContextHelper() {
        return new FileContextTestHelper();
    }

    @Before
    public void setUp() throws Exception {
        fc.mkdir(this.getTestRootPath(fc), FileContext.DEFAULT_PERM, true);
    }

    @After
    public void tearDown() throws Exception {
        fc.delete(this.getTestRootPath(fc), true);
    }

    @Test
    public void testMkdirNonRecursiveWithExistingDir() throws IOException {
        Path f = this.getTestRootPath(fc, "aDir");
        fc.mkdir(f, FileContext.DEFAULT_PERM, false);
        Assert.assertTrue((boolean)FileContextTestHelper.isDir(fc, f));
    }

    @Test
    public void testMkdirNonRecursiveWithNonExistingDir() {
        try {
            fc.mkdir(this.getTestRootPath(fc, "NonExistant/aDir"), FileContext.DEFAULT_PERM, false);
            Assert.fail((String)"Mkdir with non existing parent dir should have failed");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testMkdirRecursiveWithExistingDir() throws IOException {
        Path f = this.getTestRootPath(fc, "aDir");
        fc.mkdir(f, FileContext.DEFAULT_PERM, true);
        Assert.assertTrue((boolean)FileContextTestHelper.isDir(fc, f));
    }

    @Test
    public void testMkdirRecursiveWithNonExistingDir() throws IOException {
        Path f = this.getTestRootPath(fc, "NonExistant2/aDir");
        fc.mkdir(f, FileContext.DEFAULT_PERM, true);
        Assert.assertTrue((boolean)FileContextTestHelper.isDir(fc, f));
    }

    @Test
    public void testMkdirsRecursiveWithExistingDir() throws IOException {
        Path f = this.getTestRootPath(fc, "aDir/bDir/cDir");
        fc.mkdir(f, FileContext.DEFAULT_PERM, true);
        ContractTestUtils.assertIsDirectory(fc.getFileStatus(f));
        ContractTestUtils.assertIsDirectory(fc.getFileStatus(f.getParent()));
        ContractTestUtils.assertIsDirectory(fc.getFileStatus(f.getParent().getParent()));
    }

    @Test
    public void testMkdirRecursiveWithExistingFile() throws IOException {
        Path f = this.getTestRootPath(fc, "NonExistant3/aDir");
        fc.mkdir(f, FileContext.DEFAULT_PERM, true);
        ContractTestUtils.assertIsDirectory(fc.getFileStatus(f));
        ContractTestUtils.assertIsDirectory(fc.getFileStatus(f.getParent()));
        Path filePath = new Path(f.getParent(), "test.txt");
        FileContextTestHelper.createFile(fc, filePath);
        ContractTestUtils.assertIsFile(filePath, fc.getFileStatus(filePath));
        Path dirPath = new Path(filePath, "bDir/cDir");
        try {
            fc.mkdir(dirPath, FileContext.DEFAULT_PERM, true);
            Assert.fail((String)("Mkdir for " + dirPath + " should have failed as a file was present"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testWithRename() throws IOException, InterruptedException {
        Path root = this.getTestRootPath(fc);
        Path f = new Path(root, "d1/d2/d3");
        fc.mkdir(f, FileContext.DEFAULT_PERM, true);
        ContractTestUtils.assertIsDirectory(fc.getFileStatus(new Path(root, "d1")));
        ContractTestUtils.assertIsDirectory(fc.getFileStatus(new Path(root, "d1/d2")));
        ContractTestUtils.assertIsDirectory(fc.getFileStatus(new Path(root, "d1/d2/d3")));
        Path fPath = new Path(root, "d1/d2/f.txt");
        FileContextTestHelper.createFile(fc, fPath);
        ContractTestUtils.assertIsFile(fPath, fc.getFileStatus(fPath));
        ContractTestUtils.assertIsDirectory(fc.getFileStatus(new Path(root, "d1")));
        ContractTestUtils.assertIsDirectory(fc.getFileStatus(new Path(root, "d1/d2")));
        ContractTestUtils.assertIsDirectory(fc.getFileStatus(new Path(root, "d1/d2/d3")));
        Path f2Path = new Path(this.getTestRootPath(fc), "d1/d2/d3/f2.txt");
        FileContextTestHelper.createFile(fc, f2Path);
        ContractTestUtils.assertIsFile(fPath, fc.getFileStatus(f2Path));
        ContractTestUtils.assertIsDirectory(fc.getFileStatus(new Path(root, "d1")));
        ContractTestUtils.assertIsDirectory(fc.getFileStatus(new Path(root, "d1/d2")));
        ContractTestUtils.assertIsDirectory(fc.getFileStatus(new Path(root, "d1/d2/d3")));
        fc.rename(new Path(root, "d1/d2/d3"), new Path(root, "d1/d4"), new Options.Rename[0]);
        ContractTestUtils.assertIsDirectory(fc.getFileStatus(new Path(root, "d1")));
        ContractTestUtils.assertIsDirectory(fc.getFileStatus(new Path(root, "d1/d4")));
        Path f2NewPath = new Path(root, "d1/d4/f2.txt");
        ContractTestUtils.assertIsFile(f2NewPath, fc.getFileStatus(f2NewPath));
    }

    @Test
    public void testCreateNonRecursiveWithExistingDir() throws IOException {
        Path f = this.getTestRootPath(fc, "foo");
        FileContextTestHelper.createFile(fc, f);
        Assert.assertTrue((boolean)FileContextTestHelper.isFile(fc, f));
    }

    @Test
    public void testCreateNonRecursiveWithNonExistingDir() {
        try {
            FileContextTestHelper.createFileNonRecursive(fc, this.getTestRootPath(fc, "NonExisting/foo"));
            Assert.fail((String)"Create with non existing parent dir should have failed");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateRecursiveWithExistingDir() throws IOException {
        Path f = this.getTestRootPath(fc, "foo");
        FileContextTestHelper.createFile(fc, f);
        Assert.assertTrue((boolean)FileContextTestHelper.isFile(fc, f));
    }

    @Test
    public void testCreateRecursiveWithNonExistingDir() throws IOException {
        Path f = this.getTestRootPath(fc, "NonExisting/foo");
        FileContextTestHelper.createFile(fc, f);
        Assert.assertTrue((boolean)FileContextTestHelper.isFile(fc, f));
    }

    private Path getTestRootPath(FileContext fc) {
        return this.fileContextTestHelper.getTestRootPath(fc);
    }

    private Path getTestRootPath(FileContext fc, String pathString) {
        return this.fileContextTestHelper.getTestRootPath(fc, pathString);
    }

    static {
        GenericTestUtils.setLogLevel(FileSystem.LOG, Level.DEBUG);
    }
}

