/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.test;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LambdaTestUtils {
    public static final Logger LOG = LoggerFactory.getLogger(LambdaTestUtils.class);
    public static final String NULL_RESULT = "(null)";

    private LambdaTestUtils() {
    }

    public static int await(int timeoutMillis, Callable<Boolean> check, Callable<Integer> retry, TimeoutHandler timeoutHandler) throws Exception {
        Throwable evaluate;
        Preconditions.checkArgument((timeoutMillis >= 0 ? 1 : 0) != 0, (Object)"timeoutMillis must be >= 0");
        Preconditions.checkNotNull((Object)timeoutHandler);
        long endTime = Time.now() + (long)timeoutMillis;
        Throwable ex = null;
        boolean running = true;
        int iterations = 0;
        while (running) {
            ++iterations;
            try {
                if (check.call().booleanValue()) {
                    return iterations;
                }
                ex = null;
            }
            catch (InterruptedException | VirtualMachineError | FailFastException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.debug("eventually() iteration {}", (Object)iterations, (Object)e);
                ex = e;
            }
            if (!(running = Time.now() < endTime)) continue;
            int sleeptime = retry.call();
            if (sleeptime >= 0) {
                Thread.sleep(sleeptime);
                continue;
            }
            running = false;
        }
        try {
            evaluate = timeoutHandler.evaluate(timeoutMillis, ex);
            if (evaluate == null) {
                LOG.error("timeout handler {} did not throw an exception ", (Object)timeoutHandler);
                evaluate = new GenerateTimeout().evaluate(timeoutMillis, ex);
            }
        }
        catch (Throwable throwable) {
            evaluate = throwable;
        }
        return (Integer)LambdaTestUtils.raise(evaluate);
    }

    public static int await(int timeoutMillis, int intervalMillis, Callable<Boolean> check) throws Exception {
        return LambdaTestUtils.await(timeoutMillis, check, new FixedRetryInterval(intervalMillis), new GenerateTimeout());
    }

    public static <T> T eventually(int timeoutMillis, Callable<T> eval, Callable<Integer> retry) throws Exception {
        Preconditions.checkArgument((timeoutMillis >= 0 ? 1 : 0) != 0, (Object)"timeoutMillis must be >= 0");
        long endTime = Time.now() + (long)timeoutMillis;
        int iterations = 0;
        while (true) {
            ++iterations;
            try {
                return eval.call();
            }
            catch (InterruptedException | VirtualMachineError | FailFastException e) {
                throw e;
            }
            catch (Throwable e) {
                int sleeptime;
                boolean running;
                LOG.debug("evaluate() iteration {}", (Object)iterations, (Object)e);
                Throwable ex = e;
                boolean bl = running = Time.now() < endTime;
                if (!running || (sleeptime = retry.call().intValue()) < 0) continue;
                Thread.sleep(sleeptime);
                if (running) continue;
                return LambdaTestUtils.raise(ex);
            }
            break;
        }
    }

    private static <T> T raise(Throwable throwable) throws Exception {
        if (throwable instanceof Exception) {
            throw (Exception)throwable;
        }
        throw (Error)throwable;
    }

    public static void eventually(int timeoutMillis, VoidCallable eval, Callable<Integer> retry) throws Exception {
        LambdaTestUtils.eventually(timeoutMillis, new VoidCaller(eval), retry);
    }

    public static <T> T eventually(int timeoutMillis, int intervalMillis, Callable<T> eval) throws Exception {
        return LambdaTestUtils.eventually(timeoutMillis, eval, (Callable<Integer>)new FixedRetryInterval(intervalMillis));
    }

    public static void eventually(int timeoutMillis, int intervalMillis, VoidCallable eval) throws Exception {
        LambdaTestUtils.eventually(timeoutMillis, eval, (Callable<Integer>)new FixedRetryInterval(intervalMillis));
    }

    public static <T, E extends Throwable> E intercept(Class<E> clazz, Callable<T> eval) throws Exception {
        try {
            T result = eval.call();
            throw new AssertionError((Object)("Expected an exception, got " + LambdaTestUtils.robustToString(result)));
        }
        catch (Throwable e) {
            if (clazz.isAssignableFrom(e.getClass())) {
                return (E)e;
            }
            throw e;
        }
    }

    public static <E extends Throwable> E intercept(Class<E> clazz, VoidCallable eval) throws Exception {
        try {
            eval.call();
            throw new AssertionError((Object)"Expected an exception");
        }
        catch (Throwable e) {
            if (clazz.isAssignableFrom(e.getClass())) {
                return (E)e;
            }
            throw e;
        }
    }

    public static <T, E extends Throwable> E intercept(Class<E> clazz, String contained, Callable<T> eval) throws Exception {
        E ex = LambdaTestUtils.intercept(clazz, eval);
        GenericTestUtils.assertExceptionContains(contained, ex);
        return ex;
    }

    public static <E extends Throwable> E intercept(Class<E> clazz, String contained, VoidCallable eval) throws Exception {
        E ex = LambdaTestUtils.intercept(clazz, eval);
        GenericTestUtils.assertExceptionContains(contained, ex);
        return ex;
    }

    private static String robustToString(Object o) {
        if (o == null) {
            return NULL_RESULT;
        }
        try {
            return o.toString();
        }
        catch (Exception e) {
            LOG.info("Exception calling toString()", (Throwable)e);
            return o.getClass().toString();
        }
    }

    public static class VoidCaller
    implements Callable<Void> {
        private final VoidCallable callback;

        public VoidCaller(VoidCallable callback) {
            this.callback = callback;
        }

        @Override
        public Void call() throws Exception {
            this.callback.call();
            return null;
        }
    }

    public static interface VoidCallable {
        public void call() throws Exception;
    }

    public static class FailFastException
    extends Exception {
        public FailFastException(String detailMessage) {
            super(detailMessage);
        }

        public FailFastException(String message, Throwable cause) {
            super(message, cause);
        }

        public static FailFastException newInstance(String format, Object ... args) {
            return new FailFastException(String.format(format, args));
        }
    }

    public static class ProportionalRetryInterval
    implements Callable<Integer> {
        private final int intervalMillis;
        private final int maxIntervalMillis;
        private int current;
        private int invocationCount = 0;

        public ProportionalRetryInterval(int intervalMillis, int maxIntervalMillis) {
            Preconditions.checkArgument((intervalMillis > 0 ? 1 : 0) != 0);
            Preconditions.checkArgument((maxIntervalMillis > 0 ? 1 : 0) != 0);
            this.intervalMillis = intervalMillis;
            this.current = intervalMillis;
            this.maxIntervalMillis = maxIntervalMillis;
        }

        @Override
        public Integer call() throws Exception {
            ++this.invocationCount;
            int last = this.current;
            if (last < this.maxIntervalMillis) {
                this.current += this.intervalMillis;
            }
            return last;
        }

        public int getInvocationCount() {
            return this.invocationCount;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("ProportionalRetryInterval{");
            sb.append("interval=").append(this.intervalMillis);
            sb.append(", current=").append(this.current);
            sb.append(", limit=").append(this.maxIntervalMillis);
            sb.append(", invocationCount=").append(this.invocationCount);
            sb.append('}');
            return sb.toString();
        }
    }

    public static class FixedRetryInterval
    implements Callable<Integer> {
        private final int intervalMillis;
        private int invocationCount = 0;

        public FixedRetryInterval(int intervalMillis) {
            Preconditions.checkArgument((intervalMillis > 0 ? 1 : 0) != 0);
            this.intervalMillis = intervalMillis;
        }

        @Override
        public Integer call() throws Exception {
            ++this.invocationCount;
            return this.intervalMillis;
        }

        public int getInvocationCount() {
            return this.invocationCount;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("FixedRetryInterval{");
            sb.append("interval=").append(this.intervalMillis);
            sb.append(", invocationCount=").append(this.invocationCount);
            sb.append('}');
            return sb.toString();
        }
    }

    public static class GenerateTimeout
    implements TimeoutHandler {
        private final String message;

        public GenerateTimeout(String message) {
            this.message = message;
        }

        public GenerateTimeout() {
            this("timeout");
        }

        @Override
        public Throwable evaluate(int timeoutMillis, Throwable caught) throws Throwable {
            String s = String.format("%s: after %d millis", this.message, timeoutMillis);
            String caughtText = caught != null ? "; " + LambdaTestUtils.robustToString(caught) : "";
            return new TimeoutException(s + caughtText).initCause(caught);
        }
    }

    public static interface TimeoutHandler {
        public Throwable evaluate(int var1, Throwable var2) throws Throwable;
    }
}

