/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.mockito.internal.debugging;

import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.shaded.org.mockito.MockitoDebugger;
import org.apache.hadoop.shaded.org.mockito.internal.invocation.AllInvocationsFinder;
import org.apache.hadoop.shaded.org.mockito.internal.invocation.Invocation;
import org.apache.hadoop.shaded.org.mockito.internal.invocation.UnusedStubsFinder;

public class MockitoDebuggerImpl
implements MockitoDebugger {
    private AllInvocationsFinder allInvocationsFinder = new AllInvocationsFinder();
    private UnusedStubsFinder unusedStubsFinder = new UnusedStubsFinder();

    public String printInvocations(Object ... mocks) {
        String out = "";
        List<Invocation> invocations = this.allInvocationsFinder.find(Arrays.asList(mocks));
        out = out + this.line("********************************");
        out = out + this.line("*** Mockito interactions log ***");
        out = out + this.line("********************************");
        for (Invocation i : invocations) {
            out = out + this.line(i.toString());
            out = out + this.line(" invoked: " + i.getLocation());
            if (i.stubInfo() == null) continue;
            out = out + this.line(" stubbed: " + i.stubInfo().stubbedAt());
        }
        invocations = this.unusedStubsFinder.find(Arrays.asList(mocks));
        if (invocations.isEmpty()) {
            return this.print(out);
        }
        out = out + this.line("********************************");
        out = out + this.line("***       Unused stubs       ***");
        out = out + this.line("********************************");
        for (Invocation i : invocations) {
            out = out + this.line(i.toString());
            out = out + this.line(" stubbed: " + i.getLocation());
        }
        return this.print(out);
    }

    private String line(String text) {
        return text + "\n";
    }

    private String print(String out) {
        System.out.println(out);
        return out;
    }
}

