/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.eclipse.jetty.http;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.shaded.org.eclipse.jetty.http.QuotedCSV;

public class QuotedQualityCSV
extends QuotedCSV
implements Iterable<String> {
    private static final Double ZERO = new Double(0.0);
    private static final Double ONE = new Double(1.0);
    private final List<Double> _quality = new ArrayList<Double>();
    private boolean _sorted = false;

    public QuotedQualityCSV(String ... values) {
        super(new String[0]);
        for (String v : values) {
            this.addValue(v);
        }
    }

    @Override
    public void addValue(String value) {
        super.addValue(value);
        while (this._quality.size() < this._values.size()) {
            this._quality.add(ONE);
        }
    }

    @Override
    protected void parsedValue(StringBuffer buffer) {
        super.parsedValue(buffer);
    }

    @Override
    protected void parsedParam(StringBuffer buffer, int valueLength, int paramName, int paramValue) {
        if (paramName < 0 && buffer.charAt(buffer.length() - 1) == ';') {
            buffer.setLength(buffer.length() - 1);
        }
        if (paramValue >= 0 && buffer.charAt(paramName) == 'q' && paramValue > paramName && buffer.length() >= paramName && buffer.charAt(paramName + 1) == '=') {
            Double q;
            try {
                q = this._keepQuotes && buffer.charAt(paramValue) == '\"' ? new Double(buffer.substring(paramValue + 1, buffer.length() - 1)) : new Double(buffer.substring(paramValue));
            }
            catch (Exception e) {
                q = ZERO;
            }
            buffer.setLength(paramName - 1);
            while (this._quality.size() < this._values.size()) {
                this._quality.add(ONE);
            }
            this._quality.add(q);
        }
    }

    @Override
    public List<String> getValues() {
        if (!this._sorted) {
            this.sort();
        }
        return this._values;
    }

    @Override
    public Iterator<String> iterator() {
        if (!this._sorted) {
            this.sort();
        }
        return this._values.iterator();
    }

    protected void sort() {
        this._sorted = true;
        Double last = ZERO;
        int i = this._values.size();
        while (i-- > 0) {
            String v = (String)this._values.get(i);
            Double q = this._quality.get(i);
            int compare = last.compareTo(q);
            if (compare > 0) {
                this._values.set(i, this._values.get(i + 1));
                this._values.set(i + 1, v);
                this._quality.set(i, this._quality.get(i + 1));
                this._quality.set(i + 1, q);
                last = ZERO;
                i = this._values.size();
                continue;
            }
            last = q;
        }
        int last_element = this._quality.size();
        while (last_element > 0 && this._quality.get(--last_element).equals(ZERO)) {
            this._quality.remove(last_element);
            this._values.remove(last_element);
        }
    }
}

