/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.slive;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.slive.ConfigExtractor;
import org.apache.hadoop.fs.slive.Operation;
import org.apache.hadoop.fs.slive.OperationOutput;
import org.apache.hadoop.fs.slive.Timer;

class RenameOp
extends Operation {
    private static final Log LOG = LogFactory.getLog(RenameOp.class);

    RenameOp(ConfigExtractor cfg, Random rnd) {
        super(RenameOp.class.getSimpleName(), cfg, rnd);
    }

    protected SrcTarget getRenames() {
        Path src = this.getFinder().getFile();
        Path target = this.getFinder().getFile();
        return new SrcTarget(src, target);
    }

    @Override
    List<OperationOutput> run(FileSystem fs) {
        List<OperationOutput> out = super.run(fs);
        try {
            SrcTarget targets = this.getRenames();
            Path src = targets.getSrc();
            Path target = targets.getTarget();
            boolean renamedOk = false;
            long timeTaken = 0L;
            long startTime = Timer.now();
            renamedOk = fs.rename(src, target);
            timeTaken = Timer.elapsed(startTime);
            if (renamedOk) {
                out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "milliseconds_taken", timeTaken));
                out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "successes", 1L));
                LOG.info((Object)("Renamed " + src + " to " + target));
            } else {
                out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "failures", 1L));
                LOG.warn((Object)("Could not rename " + src + " to " + target));
            }
        }
        catch (FileNotFoundException e) {
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "files_not_found", 1L));
            LOG.warn((Object)"Error with renaming", (Throwable)e);
        }
        catch (IOException e) {
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "failures", 1L));
            LOG.warn((Object)"Error with renaming", (Throwable)e);
        }
        return out;
    }

    protected static class SrcTarget {
        private Path src;
        private Path target;

        SrcTarget(Path src, Path target) {
            this.src = src;
            this.target = target;
        }

        Path getSrc() {
            return this.src;
        }

        Path getTarget() {
            return this.target;
        }
    }
}

