/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ant;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.util.LinkedList;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

@InterfaceAudience.Private
public class DfsTask
extends Task {
    private static final OutputStream nullOut;
    private static final FsShell shell;
    protected AntClassLoader confloader;
    protected OutputStream out = nullOut;
    protected OutputStream err = nullOut;
    protected String cmd;
    protected final LinkedList<String> argv = new LinkedList();
    protected String outprop;
    protected String errprop;
    protected boolean failonerror = true;
    private PrintStream antOut;
    private PrintStream antErr;

    public void setCmd(String cmd) {
        this.cmd = "-" + cmd.trim();
    }

    public void setArgs(String args) {
        for (String s : args.trim().split("\\s*,\\s*")) {
            this.argv.add(s);
        }
    }

    public void setOut(String outprop) {
        this.outprop = outprop;
        this.out = new ByteArrayOutputStream();
        if (outprop.equals(this.errprop)) {
            this.err = this.out;
        }
    }

    public void setErr(String errprop) {
        OutputStream outputStream;
        this.errprop = errprop;
        if (errprop.equals(this.outprop)) {
            this.err = this.out;
            outputStream = this.err;
        } else {
            outputStream = new ByteArrayOutputStream();
        }
        this.err = outputStream;
    }

    public void setConf(String confpath) {
        this.confloader = (AntClassLoader)AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */);
        this.confloader.setProject(this.getProject());
        if (null != confpath) {
            this.confloader.addPathElement(confpath);
        }
    }

    public void setFailonerror(boolean failonerror) {
        this.failonerror = failonerror;
    }

    protected void pushContext() {
        this.antOut = System.out;
        this.antErr = System.err;
        try {
            System.setOut(new PrintStream(this.out, false, "UTF-8"));
            System.setErr(this.out == this.err ? System.out : new PrintStream(this.err, false, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    protected void popContext() {
        if (this.outprop != null && !System.out.checkError()) {
            this.getProject().setNewProperty(this.outprop, this.out.toString());
        }
        if (this.out != this.err && this.errprop != null && !System.err.checkError()) {
            this.getProject().setNewProperty(this.errprop, this.err.toString());
        }
        System.setErr(this.antErr);
        System.setOut(this.antOut);
        this.confloader.cleanup();
        this.confloader.setParent(null);
    }

    protected int postCmd(int exit_code) {
        if ("-test".equals(this.cmd) && exit_code != 0) {
            this.outprop = null;
        }
        return exit_code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (null == this.cmd) {
            throw new BuildException("Missing command (cmd) argument");
        }
        this.argv.add(0, this.cmd);
        if (null == this.confloader) {
            this.setConf(this.getProject().getProperty("hadoop.conf.dir"));
        }
        int exit_code = 0;
        try {
            this.pushContext();
            Configuration conf = new Configuration();
            conf.setClassLoader((ClassLoader)this.confloader);
            exit_code = ToolRunner.run((Configuration)conf, (Tool)shell, (String[])this.argv.toArray(new String[this.argv.size()]));
            exit_code = this.postCmd(exit_code);
            if (0 > exit_code) {
                StringBuilder msg = new StringBuilder();
                for (String s : this.argv) {
                    msg.append(s + " ");
                }
                msg.append("failed: " + exit_code);
                throw new Exception(msg.toString());
            }
        }
        catch (Exception e) {
            if (this.failonerror) {
                throw new BuildException((Throwable)e);
            }
        }
        finally {
            this.popContext();
        }
    }

    static {
        Configuration.addDefaultResource((String)"hdfs-default.xml");
        Configuration.addDefaultResource((String)"hdfs-site.xml");
        nullOut = new /* Unavailable Anonymous Inner Class!! */;
        shell = new FsShell();
    }
}

