/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.request_allocation;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.gobblin.util.ExecutorsUtils;
import org.apache.gobblin.util.executors.IteratorExecutor;
import org.apache.gobblin.util.request_allocation.AllocatedRequestsIterator;
import org.apache.gobblin.util.request_allocation.AllocatedRequestsIteratorBase;
import org.apache.gobblin.util.request_allocation.ConcurrentBoundedPriorityIterable;
import org.apache.gobblin.util.request_allocation.Request;
import org.apache.gobblin.util.request_allocation.RequestAllocator;
import org.apache.gobblin.util.request_allocation.RequestAllocatorConfig;
import org.apache.gobblin.util.request_allocation.Requestor;
import org.apache.gobblin.util.request_allocation.ResourcePool;
import org.slf4j.Logger;

public abstract class PriorityIterableBasedRequestAllocator<T extends Request<T>>
implements RequestAllocator<T> {
    private final Logger log;
    private final RequestAllocatorConfig<T> configuration;
    private List<T> requestsExceedingAvailableResourcePool;
    private List<T> requestsRejectedWithLowPriority;
    private List<T> requestsRejectedDueToInsufficientEviction;
    private List<T> requestsDropped;

    public PriorityIterableBasedRequestAllocator(Logger log, RequestAllocatorConfig<T> configuration) {
        this.log = log;
        this.configuration = configuration;
    }

    @Override
    public AllocatedRequestsIterator<T> allocateRequests(Iterator<? extends Requestor<T>> requestors, ResourcePool resourcePool) {
        final ConcurrentBoundedPriorityIterable<T> iterable = new ConcurrentBoundedPriorityIterable<T>(this.configuration.getPrioritizer(), this.configuration.getResourceEstimator(), this.configuration.getStoreRejectedRequestsSetting(), resourcePool);
        Iterator<T> joinIterator = this.getJoinIterator(requestors, iterable);
        if (this.configuration.getAllowedThreads() <= 1) {
            while (joinIterator.hasNext()) {
                iterable.add(joinIterator.next());
            }
        } else {
            IteratorExecutor executor = new IteratorExecutor(Iterators.transform(joinIterator, (Function)new Function<T, Callable<Void>>(){

                public Callable<Void> apply(final T input) {
                    return new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            iterable.add(input);
                            return null;
                        }
                    };
                }
            }), this.configuration.getAllowedThreads(), ExecutorsUtils.newThreadFactory((Optional<Logger>)Optional.of((Object)this.log), (Optional<String>)Optional.of((Object)"request-allocator-%d")));
            try {
                List results = executor.executeAndGetResults();
                IteratorExecutor.logAndThrowFailures(results, this.log, 10);
            }
            catch (InterruptedException ie) {
                this.log.error("Request allocation was interrupted.");
                return new AllocatedRequestsIteratorBase(Iterators.emptyIterator(), resourcePool);
            }
        }
        iterable.logStatistics((Optional<Logger>)Optional.of((Object)this.log));
        this.getRejectedAndDroppedRequests(iterable);
        return new AllocatedRequestsIteratorBase<T>(iterable.iterator(), resourcePool);
    }

    public void getRejectedAndDroppedRequests(ConcurrentBoundedPriorityIterable<T> iterable) {
        this.requestsExceedingAvailableResourcePool = iterable.getRequestsExceedingAvailableResourcePool();
        this.requestsRejectedWithLowPriority = iterable.getRequestsRejectedWithLowPriority();
        this.requestsRejectedDueToInsufficientEviction = iterable.getRequestsRejectedDueToInsufficientEviction();
        this.requestsDropped = iterable.getRequestsDropped();
    }

    protected abstract Iterator<T> getJoinIterator(Iterator<? extends Requestor<T>> var1, ConcurrentBoundedPriorityIterable<T> var2);

    protected RequestAllocatorConfig<T> getConfiguration() {
        return this.configuration;
    }

    public List<T> getRequestsExceedingAvailableResourcePool() {
        return this.requestsExceedingAvailableResourcePool;
    }

    public List<T> getRequestsRejectedWithLowPriority() {
        return this.requestsRejectedWithLowPriority;
    }

    public List<T> getRequestsRejectedDueToInsufficientEviction() {
        return this.requestsRejectedDueToInsufficientEviction;
    }

    public List<T> getRequestsDropped() {
        return this.requestsDropped;
    }
}

