/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.recordcount;

import java.io.IOException;
import java.util.Random;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.gobblin.util.RecordCountProvider;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class LateFileRecordCountProvider
extends RecordCountProvider {
    private static final String SEPARATOR = ".";
    private static final String LATE_COMPONENT = ".late";
    private static final String EMPTY_STRING = "";
    private RecordCountProvider recordCountProviderWithoutSuffix;

    public Path constructLateFilePath(String originalFilename, FileSystem fs, Path outputDir) throws IOException {
        if (!fs.exists(new Path(outputDir, originalFilename))) {
            return new Path(outputDir, originalFilename);
        }
        return this.constructLateFilePath(FilenameUtils.getBaseName((String)originalFilename) + LATE_COMPONENT + new Random().nextInt(Integer.MAX_VALUE) + SEPARATOR + FilenameUtils.getExtension((String)originalFilename), fs, outputDir);
    }

    public static Path restoreFilePath(Path path) {
        return new Path(path.getName().replaceAll(Pattern.quote(LATE_COMPONENT) + "[\\d]*", EMPTY_STRING));
    }

    public long getRecordCount(Path path) {
        return this.recordCountProviderWithoutSuffix.getRecordCount(LateFileRecordCountProvider.restoreFilePath(path));
    }

    public LateFileRecordCountProvider(RecordCountProvider recordCountProviderWithoutSuffix) {
        this.recordCountProviderWithoutSuffix = recordCountProviderWithoutSuffix;
    }
}

