/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.limiter;

import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.RateLimiter;
import com.typesafe.config.Config;
import java.io.Closeable;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.annotation.Alias;
import org.apache.gobblin.util.limiter.Limiter;
import org.apache.gobblin.util.limiter.LimiterFactory;
import org.apache.gobblin.util.limiter.NonRefillableLimiter;

public class RateBasedLimiter
extends NonRefillableLimiter {
    private final RateLimiter rateLimiter;
    private double rateLimitPerSecond;

    public RateBasedLimiter(double rateLimit) {
        this(rateLimit, TimeUnit.SECONDS);
    }

    public RateBasedLimiter(double rateLimit, TimeUnit timeUnit) {
        this.rateLimitPerSecond = RateBasedLimiter.convertRate(rateLimit, timeUnit, TimeUnit.SECONDS);
        this.rateLimiter = RateLimiter.create((double)this.rateLimitPerSecond);
    }

    @Override
    public void start() {
    }

    @Override
    public Closeable acquirePermits(long permits) throws InterruptedException {
        this.rateLimiter.acquire(Ints.checkedCast((long)permits));
        return NO_OP_CLOSEABLE;
    }

    @Override
    public void stop() {
    }

    private static double convertRate(double originalRate, TimeUnit originalTimeUnit, TimeUnit targetTimeUnit) {
        return originalRate / (double)targetTimeUnit.convert(1L, originalTimeUnit);
    }

    public double getRateLimitPerSecond() {
        return this.rateLimitPerSecond;
    }

    @Alias(value="qps")
    public static class Factory
    implements LimiterFactory {
        public static final String QPS_KEY = "qps";

        @Override
        public Limiter buildLimiter(Config config) {
            if (!config.hasPath(QPS_KEY)) {
                throw new RuntimeException("Missing key qps");
            }
            return new RateBasedLimiter(config.getDouble(QPS_KEY));
        }
    }
}

