/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.filesystem;

import org.apache.gobblin.util.Decorator;
import org.apache.gobblin.util.filesystem.PathAlterationListener;
import org.apache.gobblin.util.filesystem.PathAlterationObserver;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionCatchingPathAlterationListenerDecorator
implements PathAlterationListener,
Decorator {
    private static final Logger log = LoggerFactory.getLogger(ExceptionCatchingPathAlterationListenerDecorator.class);
    private final PathAlterationListener underlying;

    public Object getDecoratedObject() {
        return this.underlying;
    }

    @Override
    public void onStart(PathAlterationObserver observer) {
        try {
            this.underlying.onStart(observer);
        }
        catch (Throwable exc) {
            log.error("onStart failure: ", exc);
        }
    }

    @Override
    public void onFileCreate(Path path) {
        try {
            this.underlying.onFileCreate(path);
        }
        catch (Throwable exc) {
            log.error("onFileCreate failure: ", exc);
        }
    }

    @Override
    public void onFileChange(Path path) {
        try {
            this.underlying.onFileChange(path);
        }
        catch (Throwable exc) {
            log.error("onFileChange failure: ", exc);
        }
    }

    @Override
    public void onStop(PathAlterationObserver observer) {
        try {
            this.underlying.onStop(observer);
        }
        catch (Throwable exc) {
            log.error("onStop failure: ", exc);
        }
    }

    @Override
    public void onDirectoryCreate(Path directory) {
        try {
            this.underlying.onDirectoryCreate(directory);
        }
        catch (Throwable exc) {
            log.error("onDirectoryCreate failure: ", exc);
        }
    }

    @Override
    public void onDirectoryChange(Path directory) {
        try {
            this.underlying.onDirectoryChange(directory);
        }
        catch (Throwable exc) {
            log.error("onDirectoryChange failure: ", exc);
        }
    }

    @Override
    public void onDirectoryDelete(Path directory) {
        try {
            this.underlying.onDirectoryDelete(directory);
        }
        catch (Throwable exc) {
            log.error("onDirectoryDelete failure: ", exc);
        }
    }

    @Override
    public void onFileDelete(Path path) {
        try {
            this.underlying.onFileDelete(path);
        }
        catch (Throwable exc) {
            log.error("onFileDelete failure: ", exc);
        }
    }

    public ExceptionCatchingPathAlterationListenerDecorator(PathAlterationListener underlying) {
        this.underlying = underlying;
    }
}

