/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.executors;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;

class ScalingQueue
extends LinkedBlockingQueue<Runnable> {
    private static final long serialVersionUID = -4522307109241425248L;
    private transient ThreadPoolExecutor executor;

    public ScalingQueue() {
    }

    public ScalingQueue(int capacity) {
        super(capacity);
    }

    public synchronized void setThreadPoolExecutor(ThreadPoolExecutor executor) {
        this.executor = executor;
    }

    @Override
    public synchronized boolean offer(Runnable runnable) {
        int allWorkingThreads = this.executor.getActiveCount() + super.size();
        return allWorkingThreads < this.executor.getPoolSize() && super.offer(runnable);
    }
}

