/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util;

import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.source.workunit.Extract;

public class PublisherUtils {
    public static Multimap<Extract, WorkUnitState> createExtractToWorkUnitStateMap(Collection<? extends WorkUnitState> workUnitStates) {
        ArrayListMultimap extractToWorkUnitStateMap = ArrayListMultimap.create();
        for (WorkUnitState workUnitState : workUnitStates) {
            extractToWorkUnitStateMap.put((Object)workUnitState.getExtract(), (Object)workUnitState);
        }
        return extractToWorkUnitStateMap;
    }

    public static Multimap<Extract, WorkUnitState> getExtractsForPredicate(Multimap<Extract, WorkUnitState> extractToWorkUnitStateMap, Predicate<WorkUnitState> predicate) {
        ArrayListMultimap successfulExtracts = ArrayListMultimap.create();
        for (Map.Entry entry : extractToWorkUnitStateMap.asMap().entrySet()) {
            if (!Iterables.all((Iterable)((Iterable)entry.getValue()), predicate)) continue;
            successfulExtracts.putAll(entry.getKey(), (Iterable)entry.getValue());
        }
        return successfulExtracts;
    }

    public static SplitExtractsResult splitExtractsByPredicate(Multimap<Extract, WorkUnitState> extractToWorkUnitStateMap, Predicate<WorkUnitState> predicate) {
        ArrayListMultimap retained = ArrayListMultimap.create();
        ArrayListMultimap filtered = ArrayListMultimap.create();
        for (Map.Entry entry : extractToWorkUnitStateMap.asMap().entrySet()) {
            if (Iterables.all((Iterable)((Iterable)entry.getValue()), predicate)) {
                retained.putAll(entry.getKey(), (Iterable)entry.getValue());
                continue;
            }
            filtered.putAll(entry.getKey(), (Iterable)entry.getValue());
        }
        return new SplitExtractsResult((Multimap<Extract, WorkUnitState>)retained, (Multimap<Extract, WorkUnitState>)filtered);
    }

    public static class SplitExtractsResult {
        private Multimap<Extract, WorkUnitState> retained;
        private Multimap<Extract, WorkUnitState> filtered;

        public SplitExtractsResult(Multimap<Extract, WorkUnitState> retained, Multimap<Extract, WorkUnitState> filtered) {
            this.retained = retained;
            this.filtered = filtered;
        }

        public Multimap<Extract, WorkUnitState> getRetained() {
            return this.retained;
        }

        public Multimap<Extract, WorkUnitState> getFiltered() {
            return this.filtered;
        }
    }

    public static class WorkUnitStateSuccess
    implements Predicate<WorkUnitState> {
        public boolean apply(WorkUnitState workUnitState) {
            return workUnitState.getWorkingState().equals((Object)WorkUnitState.WorkingState.SUCCESSFUL);
        }
    }
}

