/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.net.URI;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import lombok.NonNull;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.util.ProxiedFileSystemUtils;
import org.apache.gobblin.util.RateControlledFileSystem;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.token.Token;

public class ProxiedFileSystemCache {
    private static final String KEY_SEPARATOR = ";";
    private static final String RATE_CONTROLLED_TOKEN = "RateControlled";
    private static final int DEFAULT_MAX_CACHE_SIZE = 1000;
    private static final Cache<String, FileSystem> USER_NAME_TO_FILESYSTEM_CACHE = CacheBuilder.newBuilder().maximumSize(1000L).build();

    @Deprecated
    public static FileSystem getProxiedFileSystem(@NonNull String userNameToProxyAs, Properties properties, URI fsURI) throws IOException {
        if (userNameToProxyAs == null) {
            throw new NullPointerException("userNameToProxyAs is marked non-null but is null");
        }
        return ProxiedFileSystemCache.getProxiedFileSystem(userNameToProxyAs, properties, fsURI, new Configuration());
    }

    @Deprecated
    public static FileSystem getProxiedFileSystem(@NonNull String userNameToProxyAs, Properties properties, Configuration conf) throws IOException {
        if (userNameToProxyAs == null) {
            throw new NullPointerException("userNameToProxyAs is marked non-null but is null");
        }
        return ProxiedFileSystemCache.getProxiedFileSystem(userNameToProxyAs, properties, FileSystem.getDefaultUri((Configuration)conf), conf);
    }

    @Deprecated
    public static FileSystem getProxiedFileSystem(@NonNull String userNameToProxyAs, Properties properties, URI fsURI, Configuration configuration) throws IOException {
        if (userNameToProxyAs == null) {
            throw new NullPointerException("userNameToProxyAs is marked non-null but is null");
        }
        return ProxiedFileSystemCache.getProxiedFileSystem(userNameToProxyAs, properties, fsURI, configuration, null);
    }

    private static FileSystem getProxiedFileSystem(@NonNull String userNameToProxyAs, Properties properties, URI fsURI, Configuration configuration, FileSystem referenceFS) throws IOException {
        Preconditions.checkNotNull((Object)userNameToProxyAs, (Object)"Must provide a user name to proxy as.");
        Preconditions.checkNotNull((Object)properties, (Object)"Properties is a mandatory field for proxiedFileSystem generation.");
        URI actualURI = ProxiedFileSystemCache.resolveUri(fsURI, configuration, referenceFS);
        Configuration actualConfiguration = ProxiedFileSystemCache.resolveConfiguration(configuration, referenceFS);
        try {
            return (FileSystem)USER_NAME_TO_FILESYSTEM_CACHE.get((Object)ProxiedFileSystemCache.getFileSystemKey(actualURI, userNameToProxyAs, referenceFS), (Callable)new CreateProxiedFileSystemFromProperties(userNameToProxyAs, properties, actualURI, actualConfiguration, referenceFS));
        }
        catch (ExecutionException ee) {
            throw new IOException("Failed to get proxied file system for user " + userNameToProxyAs, ee);
        }
    }

    @Deprecated
    public static FileSystem getProxiedFileSystemUsingKeytab(State state, URI fsURI, Configuration conf) throws ExecutionException {
        Preconditions.checkArgument((boolean)state.contains("fs.proxy.as.user.name"));
        Preconditions.checkArgument((boolean)state.contains("super.user.name.to.proxy.as.others"));
        Preconditions.checkArgument((boolean)state.contains("super.user.key.tab.location"));
        return ProxiedFileSystemCache.getProxiedFileSystemUsingKeytab(state.getProp("fs.proxy.as.user.name"), state.getProp("super.user.name.to.proxy.as.others"), new Path(state.getProp("super.user.key.tab.location")), fsURI, conf);
    }

    @Deprecated
    public static FileSystem getProxiedFileSystemUsingKeytab(@NonNull String userNameToProxyAs, String superUserName, Path superUserKeytabLocation, URI fsURI, Configuration conf) throws ExecutionException {
        if (userNameToProxyAs == null) {
            throw new NullPointerException("userNameToProxyAs is marked non-null but is null");
        }
        try {
            return ProxiedFileSystemCache.getProxiedFileSystemUsingKeytab(userNameToProxyAs, superUserName, superUserKeytabLocation, fsURI, conf, null);
        }
        catch (IOException ioe) {
            throw new ExecutionException(ioe);
        }
    }

    private static FileSystem getProxiedFileSystemUsingKeytab(@NonNull String userNameToProxyAs, String superUserName, Path superUserKeytabLocation, URI fsURI, Configuration conf, FileSystem referenceFS) throws IOException, ExecutionException {
        Preconditions.checkNotNull((Object)userNameToProxyAs, (Object)"Must provide a user name to proxy as.");
        Preconditions.checkNotNull((Object)superUserName, (Object)"Must provide a super user name.");
        Preconditions.checkNotNull((Object)superUserKeytabLocation, (Object)"Must provide a keytab location.");
        URI actualURI = ProxiedFileSystemCache.resolveUri(fsURI, conf, referenceFS);
        Configuration actualConfiguration = ProxiedFileSystemCache.resolveConfiguration(conf, referenceFS);
        return (FileSystem)USER_NAME_TO_FILESYSTEM_CACHE.get((Object)ProxiedFileSystemCache.getFileSystemKey(actualURI, userNameToProxyAs, referenceFS), (Callable)new CreateProxiedFileSystemFromKeytab(userNameToProxyAs, superUserName, superUserKeytabLocation, actualURI, actualConfiguration, referenceFS));
    }

    @Deprecated
    public static FileSystem getProxiedFileSystemUsingToken(@NonNull String userNameToProxyAs, Token<?> userNameToken, URI fsURI, Configuration conf) throws ExecutionException {
        if (userNameToProxyAs == null) {
            throw new NullPointerException("userNameToProxyAs is marked non-null but is null");
        }
        try {
            return ProxiedFileSystemCache.getProxiedFileSystemUsingToken(userNameToProxyAs, userNameToken, fsURI, conf, null);
        }
        catch (IOException ioe) {
            throw new ExecutionException(ioe);
        }
    }

    private static FileSystem getProxiedFileSystemUsingToken(@NonNull String userNameToProxyAs, Token<?> userNameToken, URI fsURI, Configuration conf, FileSystem referenceFS) throws IOException, ExecutionException {
        Preconditions.checkNotNull((Object)userNameToProxyAs, (Object)"Must provide a user name to proxy as.");
        Preconditions.checkNotNull(userNameToken, (Object)"Must provide token for user to proxy.");
        URI actualURI = ProxiedFileSystemCache.resolveUri(fsURI, conf, referenceFS);
        Configuration actualConfiguration = ProxiedFileSystemCache.resolveConfiguration(conf, referenceFS);
        return (FileSystem)USER_NAME_TO_FILESYSTEM_CACHE.get((Object)ProxiedFileSystemCache.getFileSystemKey(actualURI, userNameToProxyAs, referenceFS), (Callable)new CreateProxiedFileSystemFromToken(userNameToProxyAs, userNameToken, actualURI, actualConfiguration, referenceFS));
    }

    private static URI resolveUri(URI uri, Configuration configuration, FileSystem fileSystem) throws IOException {
        if (uri != null) {
            return uri;
        }
        if (fileSystem != null) {
            return fileSystem.getUri();
        }
        if (configuration != null) {
            return FileSystem.getDefaultUri((Configuration)configuration);
        }
        throw new IOException("FileSystem URI could not be determined from available inputs.");
    }

    private static Configuration resolveConfiguration(Configuration configuration, FileSystem fileSystem) throws IOException {
        if (configuration != null) {
            return configuration;
        }
        if (fileSystem != null) {
            return fileSystem.getConf();
        }
        throw new IOException("FileSystem configuration could not be determined from available inputs.");
    }

    private static String getFileSystemKey(URI uri, String user, FileSystem referenceFS) {
        StringBuilder keyBuilder = new StringBuilder();
        keyBuilder.append(uri.toString());
        keyBuilder.append(KEY_SEPARATOR);
        keyBuilder.append(user);
        if (referenceFS != null && RateControlledFileSystem.getRateIfRateControlled(referenceFS).isPresent()) {
            keyBuilder.append(KEY_SEPARATOR);
            keyBuilder.append(RATE_CONTROLLED_TOKEN);
        }
        return keyBuilder.toString();
    }

    private static FileSystem decorateFilesystemFromReferenceFS(FileSystem newFS, FileSystem referenceFS) {
        Optional<Long> referenceRateOpt;
        FileSystem decoratedFs = newFS;
        Optional<Long> decoratedFSRateOpt = RateControlledFileSystem.getRateIfRateControlled(decoratedFs);
        if (!decoratedFSRateOpt.isPresent() && (referenceRateOpt = RateControlledFileSystem.getRateIfRateControlled(referenceFS)).isPresent()) {
            decoratedFs = new RateControlledFileSystem(decoratedFs, (Long)referenceRateOpt.get());
        }
        return decoratedFs;
    }

    public static ProxiedFileSystemFromProperties fromProperties() {
        return new ProxiedFileSystemFromProperties();
    }

    public static ProxiedFileSystemFromKeytab fromKeytab() {
        return new ProxiedFileSystemFromKeytab();
    }

    public static ProxiedFileSystemFromToken fromToken() {
        return new ProxiedFileSystemFromToken();
    }

    public static class ProxiedFileSystemFromToken {
        private String userNameToProxyAs;
        private Token<?> userNameToken;
        private URI fsURI;
        private Configuration conf;
        private FileSystem referenceFS;

        ProxiedFileSystemFromToken() {
        }

        public ProxiedFileSystemFromToken userNameToProxyAs(@NonNull String userNameToProxyAs) {
            if (userNameToProxyAs == null) {
                throw new NullPointerException("userNameToProxyAs is marked non-null but is null");
            }
            this.userNameToProxyAs = userNameToProxyAs;
            return this;
        }

        public ProxiedFileSystemFromToken userNameToken(Token<?> userNameToken) {
            this.userNameToken = userNameToken;
            return this;
        }

        public ProxiedFileSystemFromToken fsURI(URI fsURI) {
            this.fsURI = fsURI;
            return this;
        }

        public ProxiedFileSystemFromToken conf(Configuration conf) {
            this.conf = conf;
            return this;
        }

        public ProxiedFileSystemFromToken referenceFS(FileSystem referenceFS) {
            this.referenceFS = referenceFS;
            return this;
        }

        public FileSystem build() throws IOException, ExecutionException {
            return ProxiedFileSystemCache.getProxiedFileSystemUsingToken(this.userNameToProxyAs, this.userNameToken, this.fsURI, this.conf, this.referenceFS);
        }

        public String toString() {
            return "ProxiedFileSystemCache.ProxiedFileSystemFromToken(userNameToProxyAs=" + this.userNameToProxyAs + ", userNameToken=" + this.userNameToken + ", fsURI=" + this.fsURI + ", conf=" + this.conf + ", referenceFS=" + this.referenceFS + ")";
        }
    }

    public static class ProxiedFileSystemFromKeytab {
        private String userNameToProxyAs;
        private String superUserName;
        private Path superUserKeytabLocation;
        private URI fsURI;
        private Configuration conf;
        private FileSystem referenceFS;

        ProxiedFileSystemFromKeytab() {
        }

        public ProxiedFileSystemFromKeytab userNameToProxyAs(@NonNull String userNameToProxyAs) {
            if (userNameToProxyAs == null) {
                throw new NullPointerException("userNameToProxyAs is marked non-null but is null");
            }
            this.userNameToProxyAs = userNameToProxyAs;
            return this;
        }

        public ProxiedFileSystemFromKeytab superUserName(String superUserName) {
            this.superUserName = superUserName;
            return this;
        }

        public ProxiedFileSystemFromKeytab superUserKeytabLocation(Path superUserKeytabLocation) {
            this.superUserKeytabLocation = superUserKeytabLocation;
            return this;
        }

        public ProxiedFileSystemFromKeytab fsURI(URI fsURI) {
            this.fsURI = fsURI;
            return this;
        }

        public ProxiedFileSystemFromKeytab conf(Configuration conf) {
            this.conf = conf;
            return this;
        }

        public ProxiedFileSystemFromKeytab referenceFS(FileSystem referenceFS) {
            this.referenceFS = referenceFS;
            return this;
        }

        public FileSystem build() throws IOException, ExecutionException {
            return ProxiedFileSystemCache.getProxiedFileSystemUsingKeytab(this.userNameToProxyAs, this.superUserName, this.superUserKeytabLocation, this.fsURI, this.conf, this.referenceFS);
        }

        public String toString() {
            return "ProxiedFileSystemCache.ProxiedFileSystemFromKeytab(userNameToProxyAs=" + this.userNameToProxyAs + ", superUserName=" + this.superUserName + ", superUserKeytabLocation=" + this.superUserKeytabLocation + ", fsURI=" + this.fsURI + ", conf=" + this.conf + ", referenceFS=" + this.referenceFS + ")";
        }
    }

    public static class ProxiedFileSystemFromProperties {
        private String userNameToProxyAs;
        private Properties properties;
        private URI fsURI;
        private Configuration configuration;
        private FileSystem referenceFS;

        ProxiedFileSystemFromProperties() {
        }

        public ProxiedFileSystemFromProperties userNameToProxyAs(@NonNull String userNameToProxyAs) {
            if (userNameToProxyAs == null) {
                throw new NullPointerException("userNameToProxyAs is marked non-null but is null");
            }
            this.userNameToProxyAs = userNameToProxyAs;
            return this;
        }

        public ProxiedFileSystemFromProperties properties(Properties properties) {
            this.properties = properties;
            return this;
        }

        public ProxiedFileSystemFromProperties fsURI(URI fsURI) {
            this.fsURI = fsURI;
            return this;
        }

        public ProxiedFileSystemFromProperties configuration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        public ProxiedFileSystemFromProperties referenceFS(FileSystem referenceFS) {
            this.referenceFS = referenceFS;
            return this;
        }

        public FileSystem build() throws IOException {
            return ProxiedFileSystemCache.getProxiedFileSystem(this.userNameToProxyAs, this.properties, this.fsURI, this.configuration, this.referenceFS);
        }

        public String toString() {
            return "ProxiedFileSystemCache.ProxiedFileSystemFromProperties(userNameToProxyAs=" + this.userNameToProxyAs + ", properties=" + this.properties + ", fsURI=" + this.fsURI + ", configuration=" + this.configuration + ", referenceFS=" + this.referenceFS + ")";
        }
    }

    private static class CreateProxiedFileSystemFromToken
    implements Callable<FileSystem> {
        @NonNull
        private final String userNameToProxyAs;
        @NonNull
        private final Token<?> userNameToken;
        @NonNull
        private final URI uri;
        @NonNull
        private final Configuration configuration;
        private final FileSystem referenceFS;

        @Override
        public FileSystem call() throws Exception {
            FileSystem fs = ProxiedFileSystemUtils.createProxiedFileSystemUsingToken(this.userNameToProxyAs, this.userNameToken, this.uri, this.configuration);
            if (this.referenceFS != null) {
                return ProxiedFileSystemCache.decorateFilesystemFromReferenceFS(fs, this.referenceFS);
            }
            return fs;
        }

        public CreateProxiedFileSystemFromToken(@NonNull String userNameToProxyAs, @NonNull Token<?> userNameToken, @NonNull URI uri, @NonNull Configuration configuration, FileSystem referenceFS) {
            if (userNameToProxyAs == null) {
                throw new NullPointerException("userNameToProxyAs is marked non-null but is null");
            }
            if (userNameToken == null) {
                throw new NullPointerException("userNameToken is marked non-null but is null");
            }
            if (uri == null) {
                throw new NullPointerException("uri is marked non-null but is null");
            }
            if (configuration == null) {
                throw new NullPointerException("configuration is marked non-null but is null");
            }
            this.userNameToProxyAs = userNameToProxyAs;
            this.userNameToken = userNameToken;
            this.uri = uri;
            this.configuration = configuration;
            this.referenceFS = referenceFS;
        }
    }

    private static class CreateProxiedFileSystemFromKeytab
    implements Callable<FileSystem> {
        @NonNull
        private final String userNameToProxyAs;
        @NonNull
        private final String superUser;
        @NonNull
        private final Path keytabLocation;
        @NonNull
        private final URI uri;
        @NonNull
        private final Configuration configuration;
        private final FileSystem referenceFS;

        @Override
        public FileSystem call() throws Exception {
            FileSystem fs = ProxiedFileSystemUtils.createProxiedFileSystemUsingKeytab(this.userNameToProxyAs, this.superUser, this.keytabLocation, this.uri, this.configuration);
            if (this.referenceFS != null) {
                return ProxiedFileSystemCache.decorateFilesystemFromReferenceFS(fs, this.referenceFS);
            }
            return fs;
        }

        public CreateProxiedFileSystemFromKeytab(@NonNull String userNameToProxyAs, @NonNull String superUser, @NonNull Path keytabLocation, @NonNull URI uri, @NonNull Configuration configuration, FileSystem referenceFS) {
            if (userNameToProxyAs == null) {
                throw new NullPointerException("userNameToProxyAs is marked non-null but is null");
            }
            if (superUser == null) {
                throw new NullPointerException("superUser is marked non-null but is null");
            }
            if (keytabLocation == null) {
                throw new NullPointerException("keytabLocation is marked non-null but is null");
            }
            if (uri == null) {
                throw new NullPointerException("uri is marked non-null but is null");
            }
            if (configuration == null) {
                throw new NullPointerException("configuration is marked non-null but is null");
            }
            this.userNameToProxyAs = userNameToProxyAs;
            this.superUser = superUser;
            this.keytabLocation = keytabLocation;
            this.uri = uri;
            this.configuration = configuration;
            this.referenceFS = referenceFS;
        }
    }

    private static class CreateProxiedFileSystemFromProperties
    implements Callable<FileSystem> {
        @NonNull
        private final String userNameToProxyAs;
        @NonNull
        private final Properties properties;
        @NonNull
        private final URI uri;
        @NonNull
        private final Configuration configuration;
        private final FileSystem referenceFS;

        @Override
        public FileSystem call() throws Exception {
            FileSystem fs = ProxiedFileSystemUtils.createProxiedFileSystem(this.userNameToProxyAs, this.properties, this.uri, this.configuration);
            if (this.referenceFS != null) {
                return ProxiedFileSystemCache.decorateFilesystemFromReferenceFS(fs, this.referenceFS);
            }
            return fs;
        }

        public CreateProxiedFileSystemFromProperties(@NonNull String userNameToProxyAs, @NonNull Properties properties, @NonNull URI uri, @NonNull Configuration configuration, FileSystem referenceFS) {
            if (userNameToProxyAs == null) {
                throw new NullPointerException("userNameToProxyAs is marked non-null but is null");
            }
            if (properties == null) {
                throw new NullPointerException("properties is marked non-null but is null");
            }
            if (uri == null) {
                throw new NullPointerException("uri is marked non-null but is null");
            }
            if (configuration == null) {
                throw new NullPointerException("configuration is marked non-null but is null");
            }
            this.userNameToProxyAs = userNameToProxyAs;
            this.properties = properties;
            this.uri = uri;
            this.configuration = configuration;
            this.referenceFS = referenceFS;
        }
    }
}

