/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.gobblin.configuration.State;

public class DatasetFilterUtils {
    public static List<Pattern> getPatternList(State state, String propKey) {
        return DatasetFilterUtils.getPatternList(state, propKey, "");
    }

    public static List<Pattern> getPatternList(State state, String propKey, String def) {
        List list = state.getPropAsList(propKey, def);
        return DatasetFilterUtils.getPatternsFromStrings(list);
    }

    public static List<Pattern> getPatternsFromStrings(List<String> strings) {
        ArrayList patterns = Lists.newArrayList();
        for (String s : strings) {
            patterns.add(Pattern.compile(s));
        }
        return patterns;
    }

    public static List<String> filter(List<String> topics, List<Pattern> blacklist, List<Pattern> whitelist) {
        ArrayList result = Lists.newArrayList();
        for (String topic : topics) {
            if (!DatasetFilterUtils.survived(topic, blacklist, whitelist)) continue;
            result.add(topic);
        }
        return result;
    }

    public static Set<String> filter(Set<String> topics, List<Pattern> blacklist, List<Pattern> whitelist) {
        HashSet result = Sets.newHashSet();
        for (String topic : topics) {
            if (!DatasetFilterUtils.survived(topic, blacklist, whitelist)) continue;
            result.add(topic);
        }
        return result;
    }

    public static boolean survived(String topic, List<Pattern> blacklist, List<Pattern> whitelist) {
        if (DatasetFilterUtils.stringInPatterns(topic, blacklist)) {
            return false;
        }
        return whitelist.isEmpty() || DatasetFilterUtils.stringInPatterns(topic, whitelist);
    }

    public static boolean stringInPatterns(String s, List<Pattern> patterns) {
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(s).matches()) continue;
            return true;
        }
        return false;
    }
}

