/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.cli;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.gobblin.runtime.cli.CliObjectSupport;
import org.apache.gobblin.runtime.cli.PublicMethodsCliObjectFactory;

public class ConstructorAndPublicMethodsCliObjectFactory<T>
extends PublicMethodsCliObjectFactory<T> {
    private final Constructor<? extends T> constructor;
    private final Map<String, Integer> constructoArgumentsMap = Maps.newHashMap();
    private final Options options = super.getOptions();

    public ConstructorAndPublicMethodsCliObjectFactory(Class<? extends T> klazz) {
        super(klazz);
        this.constructor = this.inferConstructorOptions(this.options);
    }

    @Override
    public T constructObject(CommandLine cli) throws IOException {
        return this.buildInstance(cli);
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    private T buildInstance(CommandLine cli) {
        String[] constructorArgs = new String[this.constructor.getParameterTypes().length];
        for (Option option : cli.getOptions()) {
            if (!this.constructoArgumentsMap.containsKey(option.getOpt())) continue;
            int idx = this.constructoArgumentsMap.get(option.getOpt());
            constructorArgs[idx] = option.getValue();
        }
        try {
            T embeddedGobblin = this.constructor.newInstance(constructorArgs);
            return embeddedGobblin;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException exc) {
            throw new RuntimeException("Could not instantiate " + this.klazz.getName(), exc);
        }
    }

    private Constructor<? extends T> inferConstructorOptions(Options otherOptions) {
        Constructor<?> selectedConstructor = null;
        for (Constructor<?> constructor : this.klazz.getConstructors()) {
            if (!this.canUseConstructor(constructor)) continue;
            if (selectedConstructor == null) {
                selectedConstructor = constructor;
                continue;
            }
            throw new RuntimeException("Multiple usable constructors for " + this.klazz.getName());
        }
        if (selectedConstructor == null) {
            throw new RuntimeException("There is no usable constructor for " + this.klazz.getName());
        }
        int constructorIdx = 0;
        for (String argument : selectedConstructor.getAnnotation(CliObjectSupport.class).argumentNames()) {
            Option option = Option.builder((String)argument).required().hasArg().build();
            otherOptions.addOption(option);
            this.constructoArgumentsMap.put(option.getOpt(), constructorIdx);
            ++constructorIdx;
        }
        return selectedConstructor;
    }

    private boolean canUseConstructor(Constructor<?> constructor) {
        if (!Modifier.isPublic(constructor.getModifiers())) {
            return false;
        }
        if (!constructor.isAnnotationPresent(CliObjectSupport.class)) {
            return false;
        }
        for (Class<?> param : constructor.getParameterTypes()) {
            if (param == String.class) continue;
            return false;
        }
        return constructor.getParameterTypes().length == constructor.getAnnotation(CliObjectSupport.class).argumentNames().length;
    }
}

