/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.hive;

import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.typesafe.config.Config;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;

public class WhitelistBlacklist
implements Serializable {
    public static final String WHITELIST = "whitelist";
    public static final String BLACKLIST = "blacklist";
    public static final String IGNORE_CASE = "whitelistBlacklist.ignoreCase";
    private static final Pattern ALL_TABLES = Pattern.compile(".*");
    private final SetMultimap<Pattern, Pattern> whitelistMultimap = HashMultimap.create();
    private final SetMultimap<Pattern, Pattern> blacklistMultimap = HashMultimap.create();
    private final boolean ignoreCase;

    public WhitelistBlacklist(Config config) throws IOException {
        this(config.hasPath(WHITELIST) ? config.getString(WHITELIST) : "", config.hasPath(BLACKLIST) ? config.getString(BLACKLIST) : "", !config.hasPath(IGNORE_CASE) || config.getBoolean(IGNORE_CASE));
    }

    public WhitelistBlacklist(String whitelist, String blacklist) throws IOException {
        this(whitelist, blacklist, true);
    }

    public WhitelistBlacklist(String whitelist, String blacklist, boolean ignoreCase) throws IOException {
        this.ignoreCase = ignoreCase;
        if (ignoreCase) {
            WhitelistBlacklist.populateMultimap(this.whitelistMultimap, whitelist.toLowerCase());
            WhitelistBlacklist.populateMultimap(this.blacklistMultimap, blacklist.toLowerCase());
        } else {
            WhitelistBlacklist.populateMultimap(this.whitelistMultimap, whitelist);
            WhitelistBlacklist.populateMultimap(this.blacklistMultimap, blacklist);
        }
    }

    public boolean acceptDb(String db) {
        return this.accept(db, (Optional<String>)Optional.absent());
    }

    public boolean acceptTable(String db, String table) {
        return this.accept(db, (Optional<String>)(table == null ? Optional.absent() : Optional.fromNullable((Object)table)));
    }

    private boolean accept(String db, Optional<String> table) {
        Optional adjustedTable;
        String adjustedDb = this.ignoreCase ? db.toLowerCase() : db;
        Optional optional = adjustedTable = this.ignoreCase && table.isPresent() ? Optional.of((Object)((String)table.get()).toLowerCase()) : table;
        if (!this.blacklistMultimap.isEmpty() && WhitelistBlacklist.multimapContains(this.blacklistMultimap, adjustedDb, (Optional<String>)adjustedTable, true)) {
            return false;
        }
        return this.whitelistMultimap.isEmpty() || WhitelistBlacklist.multimapContains(this.whitelistMultimap, adjustedDb, (Optional<String>)adjustedTable, false);
    }

    private static void populateMultimap(SetMultimap<Pattern, Pattern> multimap, String list) throws IOException {
        Splitter tokenSplitter = Splitter.on((String)",").omitEmptyStrings().trimResults();
        Splitter partSplitter = Splitter.on((String)".").omitEmptyStrings().trimResults();
        Splitter tableSplitter = Splitter.on((String)"|").omitEmptyStrings().trimResults();
        for (String token : tokenSplitter.split((CharSequence)list)) {
            if (Strings.isNullOrEmpty((String)token)) continue;
            List parts = partSplitter.splitToList((CharSequence)token);
            if (parts.size() > 2) {
                throw new IOException("Invalid token " + token);
            }
            Pattern databasePattern = Pattern.compile(((String)parts.get(0)).replace("*", ".*"));
            HashSet tablePatterns = Sets.newHashSet();
            if (parts.size() == 2) {
                String tables = (String)parts.get(1);
                for (String table : tableSplitter.split((CharSequence)tables)) {
                    if (table.equals("*")) {
                        tablePatterns.add(ALL_TABLES);
                        continue;
                    }
                    tablePatterns.add(Pattern.compile(table.replace("*", ".*")));
                }
            } else {
                tablePatterns.add(ALL_TABLES);
            }
            multimap.putAll((Object)databasePattern, (Iterable)tablePatterns);
        }
    }

    private static boolean multimapContains(SetMultimap<Pattern, Pattern> multimap, String database, Optional<String> table, boolean blacklist) {
        for (Pattern dbPattern : multimap.keySet()) {
            if (!dbPattern.matcher(database).matches()) continue;
            if (!table.isPresent()) {
                return !blacklist || multimap.get((Object)dbPattern).contains(ALL_TABLES);
            }
            for (Pattern tablePattern : multimap.get((Object)dbPattern)) {
                if (!tablePattern.matcher((CharSequence)table.get()).matches()) continue;
                return true;
            }
        }
        return false;
    }
}

