/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.broker;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.gobblin.broker.DefaultBrokerCache;
import org.apache.gobblin.broker.KeyedScopedConfigViewImpl;
import org.apache.gobblin.broker.NonExtendableBrokerView;
import org.apache.gobblin.broker.ScopeWrapper;
import org.apache.gobblin.broker.SharedResourcesBrokerUtils;
import org.apache.gobblin.broker.iface.NoSuchScopeException;
import org.apache.gobblin.broker.iface.NotConfiguredException;
import org.apache.gobblin.broker.iface.ScopeInstance;
import org.apache.gobblin.broker.iface.ScopeType;
import org.apache.gobblin.broker.iface.SharedResourceFactory;
import org.apache.gobblin.broker.iface.SharedResourceKey;
import org.apache.gobblin.broker.iface.SharedResourcesBroker;
import org.apache.gobblin.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedResourcesBrokerImpl<S extends ScopeType<S>>
implements SharedResourcesBroker<S> {
    private static final Logger log = LoggerFactory.getLogger(SharedResourcesBrokerImpl.class);
    private final DefaultBrokerCache<S> brokerCache;
    private final ScopeWrapper<S> selfScopeWrapper;
    private final List<ScopedConfig<S>> scopedConfigs;
    private final ImmutableMap<S, ScopeWrapper<S>> ancestorScopesByType;

    SharedResourcesBrokerImpl(DefaultBrokerCache<S> brokerCache, ScopeWrapper<S> selfScope, List<ScopedConfig<S>> scopedConfigs, Map<S, ScopeWrapper<S>> ancestorScopesByType) {
        this.brokerCache = brokerCache;
        this.selfScopeWrapper = selfScope;
        this.scopedConfigs = scopedConfigs;
        this.ancestorScopesByType = ImmutableMap.copyOf(ancestorScopesByType);
    }

    public ScopeInstance<S> selfScope() {
        return this.selfScopeWrapper.getScope();
    }

    public ScopeInstance<S> getScope(S scopeType) throws NoSuchScopeException {
        return this.getWrappedScope(scopeType).getScope();
    }

    public <T, K extends SharedResourceKey> T getSharedResource(SharedResourceFactory<T, K, S> factory, K key) throws NotConfiguredException {
        try {
            return this.brokerCache.getAutoScoped(factory, key, this);
        }
        catch (ExecutionException ee) {
            Throwable cause = ee.getCause();
            if (cause instanceof NotConfiguredException) {
                throw (NotConfiguredException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public <T, K extends SharedResourceKey> T getSharedResourceAtScope(SharedResourceFactory<T, K, S> factory, K key, S scope) throws NotConfiguredException, NoSuchScopeException {
        try {
            return this.brokerCache.getScoped(factory, key, this.getWrappedScope(scope), this);
        }
        catch (ExecutionException ee) {
            throw new RuntimeException(ee);
        }
    }

    public <T, K extends SharedResourceKey> void bindSharedResourceAtScope(SharedResourceFactory<T, K, S> factory, K key, S scopeType, T instance) throws NoSuchScopeException {
        this.brokerCache.put(factory, key, this.getWrappedScope(scopeType), instance);
    }

    public <K extends SharedResourceKey> KeyedScopedConfigViewImpl<S, K> getConfigView(S scope, K key, String factoryName) {
        Config config = ConfigFactory.empty();
        for (ScopedConfig<S> scopedConfig : this.scopedConfigs) {
            if (scopedConfig.getScopeType().equals(scopedConfig.getScopeType().rootScope())) {
                config = ConfigUtils.getConfigOrEmpty(scopedConfig.getConfig(), factoryName).withFallback((ConfigMergeable)config);
                continue;
            }
            if (scope == null || !SharedResourcesBrokerUtils.isScopeTypeAncestor(scope, scopedConfig.getScopeType())) continue;
            Config tmpConfig = ConfigUtils.getConfigOrEmpty(scopedConfig.getConfig(), factoryName);
            tmpConfig = ConfigUtils.getConfigOrEmpty(tmpConfig, scope.name());
            config = tmpConfig.atKey(scope.name()).withFallback((ConfigMergeable)config);
        }
        return new KeyedScopedConfigViewImpl<S, K>(scope, key, factoryName, config);
    }

    NonExtendableBrokerView<S> getScopedView(S scope) throws NoSuchScopeException {
        return new NonExtendableBrokerView<S>(this.brokerCache, this.getWrappedScope(scope), this.scopedConfigs, Maps.filterKeys(this.ancestorScopesByType, (Predicate)new Predicate<S>((ScopeType)scope){
            final /* synthetic */ ScopeType val$scope;
            {
                this.val$scope = scopeType;
            }

            public boolean apply(@Nullable S input) {
                return SharedResourcesBrokerUtils.isScopeTypeAncestor(this.val$scope, input);
            }
        }));
    }

    ScopeWrapper<S> getWrappedScope(S scopeType) throws NoSuchScopeException {
        if (!this.ancestorScopesByType.containsKey(scopeType)) {
            throw new NoSuchScopeException(scopeType);
        }
        return (ScopeWrapper)this.ancestorScopesByType.get(scopeType);
    }

    ScopeWrapper<S> getWrappedSelfScope() {
        return this.selfScopeWrapper;
    }

    public SubscopedBrokerBuilder newSubscopedBuilder(ScopeInstance<S> subscope) {
        return new SubscopedBrokerBuilder(subscope);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SharedResourcesBrokerImpl that = (SharedResourcesBrokerImpl)o;
        if (!this.brokerCache.equals(that.brokerCache)) {
            return false;
        }
        if (!this.ancestorScopesByType.equals(that.ancestorScopesByType)) {
            return false;
        }
        return this.selfScopeWrapper != null ? this.selfScopeWrapper.equals(that.selfScopeWrapper) : that.selfScopeWrapper == null;
    }

    public int hashCode() {
        int result = this.brokerCache.hashCode();
        result = 31 * result + this.ancestorScopesByType.hashCode();
        result = 31 * result + (this.selfScopeWrapper != null ? this.selfScopeWrapper.hashCode() : 0);
        return result;
    }

    public void close() throws IOException {
        ScopeInstance<S> scope = this.selfScopeWrapper.getScope();
        log.info("Closing broker with scope {} of id {}.", (Object)scope.getType().toString(), (Object)scope.getScopeId());
        this.brokerCache.close(this.selfScopeWrapper);
    }

    @NotThreadSafe
    public class SubscopedBrokerBuilder
    implements org.apache.gobblin.broker.iface.SubscopedBrokerBuilder<S, SharedResourcesBrokerImpl<S>> {
        private final ScopeInstance<S> scope;
        private final Map<S, ScopeWrapper<S>> ancestorScopes = Maps.newHashMap();
        private Config config = ConfigFactory.empty();

        private SubscopedBrokerBuilder(ScopeInstance<S> scope) {
            Preconditions.checkNotNull(scope, (Object)"Subscope instance cannot be null.");
            this.scope = scope;
            if (SharedResourcesBrokerImpl.this.selfScopeWrapper != null) {
                this.ancestorScopes.put(SharedResourcesBrokerImpl.this.selfScopeWrapper.getType(), SharedResourcesBrokerImpl.this.selfScopeWrapper);
            }
        }

        public SubscopedBrokerBuilder withAdditionalParentBroker(SharedResourcesBroker<S> broker) {
            if (!(broker instanceof SharedResourcesBrokerImpl) || !((SharedResourcesBrokerImpl)broker).brokerCache.equals(SharedResourcesBrokerImpl.this.brokerCache)) {
                throw new IllegalArgumentException("Additional parent broker is not compatible.");
            }
            this.ancestorScopes.put(broker.selfScope().getType(), ((SharedResourcesBrokerImpl)broker).selfScopeWrapper);
            return this;
        }

        public SubscopedBrokerBuilder withOverridingConfig(Config config) {
            this.config = ConfigUtils.getConfigOrEmpty(config, "gobblin.broker").withFallback((ConfigMergeable)this.config);
            return this;
        }

        public SharedResourcesBrokerImpl<S> build() {
            HashMap scopeMap = Maps.newHashMap();
            for (ScopeWrapper scopeWrapper : this.ancestorScopes.values()) {
                this.addScopeAndAncestorsToScopeMap(scopeMap, scopeWrapper);
            }
            ScopeWrapper newScope = this.createWrappedScope(this.scope, scopeMap, this.scope.getType());
            if (SharedResourcesBrokerImpl.this.selfScopeWrapper != null && !SharedResourcesBrokerUtils.isScopeAncestor(newScope, SharedResourcesBrokerImpl.this.selfScopeWrapper)) {
                throw new IllegalArgumentException(String.format("Child scope %s must be a child of leaf scope %s.", newScope.getType(), SharedResourcesBrokerImpl.this.selfScopeWrapper.getType()));
            }
            ArrayList scopedConfigs = Lists.newArrayList((Iterable)SharedResourcesBrokerImpl.this.scopedConfigs);
            if (!this.config.isEmpty()) {
                scopedConfigs.add(new ScopedConfig(newScope.getType(), this.config));
            }
            return new SharedResourcesBrokerImpl(SharedResourcesBrokerImpl.this.brokerCache, newScope, scopedConfigs, scopeMap);
        }

        private ScopeWrapper<S> createWrappedScope(ScopeInstance<S> scope, Map<S, ScopeWrapper<S>> scopeMap, S mainScopeType) throws IllegalArgumentException {
            ArrayList parentScopes = Lists.newArrayList();
            ScopeType scopeType = scope.getType();
            if (scopeType.parentScopes() != null) {
                for (ScopeType tpe : scopeType.parentScopes()) {
                    if (scopeMap.containsKey(tpe)) {
                        parentScopes.add(scopeMap.get(tpe));
                        continue;
                    }
                    if (tpe.defaultScopeInstance() != null) {
                        ScopeInstance defaultInstance = tpe.defaultScopeInstance();
                        if (!defaultInstance.getType().equals(tpe)) {
                            throw new RuntimeException(String.format("Default scope instance %s for scope type %s is not of type %s.", defaultInstance, tpe, tpe));
                        }
                        parentScopes.add(this.createWrappedScope(tpe.defaultScopeInstance(), scopeMap, mainScopeType));
                        continue;
                    }
                    throw new IllegalArgumentException(String.format("Scope %s is an ancestor of %s, however it does not have a default id and is not provided as an ancestor scope.", tpe, mainScopeType));
                }
            }
            ScopeWrapper<ScopeType> wrapper = new ScopeWrapper<ScopeType>(scope.getType(), scope, parentScopes);
            scopeMap.put(wrapper.getType(), wrapper);
            return wrapper;
        }

        private void addScopeAndAncestorsToScopeMap(Map<S, ScopeWrapper<S>> scopeMap, ScopeWrapper<S> scope) {
            if (scope == null) {
                return;
            }
            LinkedList ancestors = new LinkedList();
            ancestors.add(scope);
            while (!ancestors.isEmpty()) {
                ScopeWrapper thisScope = (ScopeWrapper)ancestors.poll();
                if (!scopeMap.containsKey(thisScope.getType())) {
                    scopeMap.put(thisScope.getType(), thisScope);
                } else if (!scopeMap.get(thisScope.getType()).equals(thisScope)) {
                    throw new IllegalStateException(String.format("Multiple scopes found with type %s but different identity: %s and %s.", thisScope.getType(), thisScope.getScope(), scopeMap.get(thisScope.getType()).getScope()));
                }
                ancestors.addAll(thisScope.getParentScopes());
            }
        }
    }

    static class ScopedConfig<T extends ScopeType<T>> {
        private final T scopeType;
        private final Config config;

        public ScopedConfig(T scopeType, Config config) {
            this.scopeType = scopeType;
            this.config = config;
        }

        public T getScopeType() {
            return this.scopeType;
        }

        public Config getConfig() {
            return this.config;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScopedConfig)) {
                return false;
            }
            ScopedConfig other = (ScopedConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            T this$scopeType = this.getScopeType();
            T other$scopeType = other.getScopeType();
            if (this$scopeType == null ? other$scopeType != null : !this$scopeType.equals(other$scopeType)) {
                return false;
            }
            Config this$config = this.getConfig();
            Config other$config = other.getConfig();
            return !(this$config == null ? other$config != null : !this$config.equals(other$config));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ScopedConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            T $scopeType = this.getScopeType();
            result = result * 59 + ($scopeType == null ? 43 : $scopeType.hashCode());
            Config $config = this.getConfig();
            result = result * 59 + ($config == null ? 43 : $config.hashCode());
            return result;
        }

        public String toString() {
            return "SharedResourcesBrokerImpl.ScopedConfig(scopeType=" + this.getScopeType() + ", config=" + this.getConfig() + ")";
        }
    }
}

