/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.impl.jwtauth.jwt;

import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Base64;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.geronimo.microprofile.impl.jwtauth.JwtException;
import org.apache.geronimo.microprofile.impl.jwtauth.config.GeronimoJwtAuthConfig;

@ApplicationScoped
public class SignatureValidator {
    @Inject
    private GeronimoJwtAuthConfig config;
    private Set<String> supportedAlgorithms;
    private String jcaProvider;
    private boolean useCache;
    private final ConcurrentMap<String, PublicKey> publicKeyCache = new ConcurrentHashMap<String, PublicKey>();

    @PostConstruct
    private void init() {
        this.useCache = Boolean.parseBoolean(this.config.read("public-key.cache.active", "true"));
        this.supportedAlgorithms = Stream.of(this.config.read("header.alg.supported", "RS256").split(",")).map(String::trim).map(s -> s.toLowerCase(Locale.ROOT)).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
        this.jcaProvider = this.config.read("jca.provider", null);
    }

    public void verifySignature(String alg, String key, String signingString, String expected) {
        String normalizedAlg = alg.toLowerCase(Locale.ROOT);
        if (!this.supportedAlgorithms.contains(normalizedAlg)) {
            throw new JwtException("Unsupported algorithm", 401);
        }
        switch (normalizedAlg) {
            case "rs256": {
                this.verifySignature(this.toPublicKey(key, "RSA"), signingString, expected, "SHA256withRSA");
                break;
            }
            case "rs384": {
                this.verifySignature(this.toPublicKey(key, "RSA"), signingString, expected, "SHA384withRSA");
                break;
            }
            case "rs512": {
                this.verifySignature(this.toPublicKey(key, "RSA"), signingString, expected, "SHA512withRSA");
                break;
            }
            case "hs256": {
                this.verifyMac(this.toSecretKey(key, "HmacSHA256"), signingString, expected);
                break;
            }
            case "hs384": {
                this.verifyMac(this.toSecretKey(key, "HmacSHA384"), signingString, expected);
                break;
            }
            case "hs512": {
                this.verifyMac(this.toSecretKey(key, "HmacSHA512"), signingString, expected);
                break;
            }
            case "es256": {
                this.verifySignature(this.toPublicKey(key, "EC"), signingString, expected, "SHA256withECDSA");
                break;
            }
            case "es384": {
                this.verifySignature(this.toPublicKey(key, "EC"), signingString, expected, "SHA384withECDSA");
                break;
            }
            case "es512": {
                this.verifySignature(this.toPublicKey(key, "EC"), signingString, expected, "SHA512withECDSA");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported algorithm: " + normalizedAlg);
            }
        }
    }

    private SecretKey toSecretKey(String key, String algo) {
        return new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), algo);
    }

    private PublicKey toPublicKey(String key, String algo) {
        PublicKey publicKey;
        PublicKey publicKey2 = publicKey = this.useCache ? (PublicKey)this.publicKeyCache.get(key) : null;
        if (publicKey == null) {
            byte[] decoded = Base64.getDecoder().decode(key.replace("-----BEGIN RSA KEY-----", "").replace("-----END RSA KEY-----", "").replace("-----BEGIN PUBLIC KEY-----", "").replace("-----END PUBLIC KEY-----", "").replace("-----BEGIN RSA PUBLIC KEY-----", "").replace("-----END RSA PUBLIC KEY-----", "").replace("\n", "").trim());
            try {
                switch (algo) {
                    case "RSA": {
                        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(decoded);
                        KeyFactory keyFactory = KeyFactory.getInstance(algo);
                        publicKey = keyFactory.generatePublic(keySpec);
                        if (this.useCache) {
                            this.publicKeyCache.putIfAbsent(key, publicKey);
                        }
                        break;
                    }
                    default: {
                        throw new JwtException("Invalid signing", 401);
                    }
                }
            }
            catch (Exception e) {
                throw new JwtException("Invalid signing", 401);
            }
        }
        return publicKey;
    }

    private void verifyMac(SecretKey key, String signingString, String expected) {
        try {
            Mac signature = this.jcaProvider == null ? Mac.getInstance(key.getAlgorithm()) : Mac.getInstance(key.getAlgorithm(), this.jcaProvider);
            signature.init(key);
            signature.update(signingString.getBytes(StandardCharsets.UTF_8));
            if (!Arrays.equals(signature.doFinal(), Base64.getUrlDecoder().decode(expected))) {
                this.invalidSignature();
            }
        }
        catch (Exception e) {
            this.invalidSignature();
        }
    }

    private void verifySignature(PublicKey publicKey, String signingString, String expected, String algo) {
        try {
            Signature signature = this.jcaProvider == null ? Signature.getInstance(algo) : Signature.getInstance(algo, this.jcaProvider);
            signature.initVerify(publicKey);
            signature.update(signingString.getBytes(StandardCharsets.UTF_8));
            if (!signature.verify(Base64.getUrlDecoder().decode(expected))) {
                this.invalidSignature();
            }
        }
        catch (Exception e) {
            this.invalidSignature();
        }
    }

    private void invalidSignature() {
        throw new JwtException("Invalid signature", 401);
    }
}

