/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.impl.jwtauth.jwt;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.JsonValue;
import org.apache.geronimo.microprofile.impl.jwtauth.config.GeronimoJwtAuthConfig;
import org.apache.geronimo.microprofile.impl.jwtauth.io.PropertiesLoader;
import org.apache.geronimo.microprofile.impl.jwtauth.jwt.JWK;

@ApplicationScoped
public class KidMapper {
    @Inject
    private GeronimoJwtAuthConfig config;
    private volatile ConcurrentMap<String, String> keyMapping = new ConcurrentHashMap<String, String>();
    private final Map<String, Collection<String>> issuerMapping = new HashMap<String, Collection<String>>();
    private String defaultKey;
    private String jwksUrl;
    private String defaultKid;
    private int refreshInterval;
    private Set<String> defaultIssuers;
    private JsonReaderFactory readerFactory;
    private CompletableFuture<Void> reloadJwksRequest;
    private HttpClient httpClient;
    ScheduledExecutorService backgroundThread;

    @PostConstruct
    private void init() {
        Optional.ofNullable(this.config.read("kids.key.mapping", null)).map(String::trim).filter(s -> !s.isEmpty()).map(PropertiesLoader::load).ifPresent(props -> props.stringPropertyNames().forEach(k -> this.keyMapping.put((String)k, this.loadKey(props.getProperty((String)k)))));
        Optional.ofNullable(this.config.read("kids.issuer.mapping", null)).map(String::trim).filter(s -> !s.isEmpty()).map(PropertiesLoader::load).ifPresent(props -> props.stringPropertyNames().forEach(k -> this.issuerMapping.put((String)k, Stream.of(props.getProperty((String)k).split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toSet()))));
        this.defaultIssuers = Optional.ofNullable(this.config.read("org.eclipse.microprofile.authentication.JWT.issuers", null)).map(s -> Stream.of(s.split(",")).map(String::trim).filter(it -> !it.isEmpty()).collect(Collectors.toSet())).orElseGet(HashSet::new);
        Optional.ofNullable(this.config.read("issuer.default", this.config.read("mp.jwt.verify.issuer", null))).ifPresent(this.defaultIssuers::add);
        this.defaultKid = this.config.read("jwt.header.kid.default", null);
        this.jwksUrl = this.config.read("mp.jwt.verify.publickey.location", null);
        this.refreshInterval = Integer.parseInt(this.config.read("jwks.invalidation.interval", "0"));
        this.readerFactory = Json.createReaderFactory(Collections.emptyMap());
        Optional.ofNullable(this.jwksUrl).ifPresent(url -> {
            HttpClient.Builder builder = HttpClient.newBuilder();
            this.customize(builder);
            this.backgroundThread = this.newExecutor();
            if (this.refreshInterval > 0) {
                builder.executor(this.backgroundThread);
                this.backgroundThread.scheduleAtFixedRate(() -> this.reloadRemoteKeys(this.backgroundThread), this.refreshInterval, this.refreshInterval, TimeUnit.SECONDS);
            }
            this.httpClient = builder.build();
            this.reloadJwksRequest = this.reloadRemoteKeys(this.backgroundThread);
            if (this.refreshInterval <= 0) {
                this.reloadJwksRequest.thenRunAsync(() -> {
                    if (this.httpClient instanceof AutoCloseable) {
                        try {
                            ((AutoCloseable)this.httpClient).close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.httpClient = null;
                    this.destroy();
                }, this.backgroundThread);
            }
        });
        this.defaultKey = this.config.read("public-key.default", this.config.read("mp.jwt.verify.publickey", null));
    }

    protected ScheduledExecutorService newExecutor() {
        return Executors.newSingleThreadScheduledExecutor(worker -> new Thread(worker, KidMapper.class.getName()));
    }

    protected void customize(HttpClient.Builder builder) {
    }

    protected CompletableFuture<Void> reloadRemoteKeys(Executor executor) {
        HttpRequest request = HttpRequest.newBuilder().GET().uri(URI.create(this.jwksUrl)).header("Accept", "application/json").build();
        return this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenAcceptAsync(this::reloadRemoteKeys, executor);
    }

    private void reloadRemoteKeys(HttpResponse<String> response) {
        List<JWK> jwks = this.parseKeys(response);
        ConcurrentHashMap<String, String> newKeys = new ConcurrentHashMap<String, String>();
        jwks.forEach(key -> Optional.ofNullable(key.getKid()).ifPresent(kid -> newKeys.put((String)kid, key.toPemKey())));
        if (newKeys.isEmpty() && this.defaultKid != null && jwks.size() == 1) {
            newKeys.put(this.defaultKid, jwks.get(0).toPemKey());
        }
        this.keyMapping = newKeys;
    }

    public String loadKey(String property) {
        String value = (String)this.keyMapping.get(property);
        if (value == null) {
            value = this.tryLoad(property);
            if (value != null && !property.equals(value)) {
                this.keyMapping.putIfAbsent(property, value);
            } else if (this.defaultKey != null) {
                value = this.defaultKey;
            }
        }
        return value;
    }

    public Collection<String> loadIssuers(String property) {
        return this.issuerMapping.getOrDefault(property, this.defaultIssuers);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String tryLoad(String value) {
        File file = new File(value);
        if (file.exists()) {
            try {
                return Files.readAllLines(file.toPath()).stream().collect(Collectors.joining("\n"));
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        try (InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(value);){
            if (stream != null) {
                String string = new BufferedReader(new InputStreamReader(stream)).lines().collect(Collectors.joining("\n"));
                return string;
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        if (this.jwksUrl == null) return value;
        try {
            if (this.reloadJwksRequest != null && !this.reloadJwksRequest.isDone()) {
                this.reloadJwksRequest.get();
                this.reloadJwksRequest = null;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            RuntimeException runtimeException;
            if (e.getCause() instanceof RuntimeException) {
                runtimeException = (RuntimeException)e.getCause();
                throw runtimeException;
            }
            runtimeException = new IllegalStateException(e.getCause());
            throw runtimeException;
        }
        String key = (String)this.keyMapping.get(value);
        if (key == null) return value;
        return key;
    }

    private List<JWK> parseKeys(HttpResponse<String> keyResponse) {
        try (JsonReader reader = this.readerFactory.createReader((Reader)new StringReader(keyResponse.body()));){
            JsonObject keySet = reader.readObject();
            JsonArray keys = keySet.getJsonArray("keys");
            List<JWK> list = keys.stream().map(JsonValue::asJsonObject).map(JWK::new).filter(it -> it.getUse() == null || "sig".equals(it.getUse())).collect(Collectors.toList());
            return list;
        }
    }

    @PreDestroy
    private void destroy() {
        if (this.reloadJwksRequest != null && !this.reloadJwksRequest.isDone()) {
            this.reloadJwksRequest.cancel(true);
        }
        if (this.backgroundThread != null) {
            this.backgroundThread.shutdownNow();
            try {
                this.backgroundThread.awaitTermination(1L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

