/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.impl.jwtauth.jwt;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReaderFactory;
import javax.json.JsonString;
import org.apache.geronimo.microprofile.impl.jwtauth.JwtException;
import org.apache.geronimo.microprofile.impl.jwtauth.cdi.GeronimoJwtAuthExtension;
import org.apache.geronimo.microprofile.impl.jwtauth.config.GeronimoJwtAuthConfig;
import org.apache.geronimo.microprofile.impl.jwtauth.jwt.DateValidator;
import org.apache.geronimo.microprofile.impl.jwtauth.jwt.GeronimoJsonWebToken;
import org.apache.geronimo.microprofile.impl.jwtauth.jwt.KidMapper;
import org.apache.geronimo.microprofile.impl.jwtauth.jwt.SignatureValidator;
import org.eclipse.microprofile.jwt.Claims;
import org.eclipse.microprofile.jwt.JsonWebToken;

@ApplicationScoped
public class JwtParser {
    @Inject
    private GeronimoJwtAuthConfig config;
    @Inject
    private KidMapper kidMapper;
    @Inject
    private DateValidator dateValidator;
    @Inject
    private SignatureValidator signatureValidator;
    @Inject
    private GeronimoJwtAuthExtension extension;
    private JsonReaderFactory readerFactory;
    private String defaultKid;
    private String defaultAlg;
    private String defaultTyp;
    private boolean validateTyp;

    @PostConstruct
    private void init() {
        this.readerFactory = Json.createReaderFactory(Collections.emptyMap());
        this.defaultKid = this.config.read("jwt.header.kid.default", null);
        this.defaultAlg = this.config.read("jwt.header.alg.default", "RS256");
        this.defaultTyp = this.config.read("jwt.header.typ.default", "JWT");
        this.validateTyp = Boolean.parseBoolean(this.config.read("jwt.header.typ.validate", "true"));
    }

    public JsonWebToken parse(String jwt) {
        int firstDot = jwt.indexOf(46);
        if (firstDot < 0) {
            throw new JwtException("JWT is not valid", 400);
        }
        int secondDot = jwt.indexOf(46, firstDot + 1);
        if (secondDot < 0 || jwt.indexOf(46, secondDot + 1) > 0 || jwt.length() <= secondDot) {
            throw new JwtException("JWT is not valid", 400);
        }
        String rawHeader = jwt.substring(0, firstDot);
        JsonObject header = this.loadJson(rawHeader);
        if (this.validateTyp && !this.getAttribute(header, "typ", this.defaultTyp).equalsIgnoreCase("jwt")) {
            throw new JwtException("Invalid typ", 401);
        }
        JsonObject payload = this.loadJson(jwt.substring(firstDot + 1, secondDot));
        this.dateValidator.checkInterval(payload);
        String alg = this.getAttribute(header, "alg", this.defaultAlg);
        String kid = this.getAttribute(header, "kid", this.defaultKid);
        Collection<String> issuers = this.kidMapper.loadIssuers(kid);
        if (!issuers.isEmpty() && issuers.stream().noneMatch(it -> it.equals(payload.getString(Claims.iss.name())))) {
            throw new JwtException("Invalid issuer", 401);
        }
        this.signatureValidator.verifySignature(alg, this.kidMapper.loadKey(kid), jwt.substring(0, secondDot), jwt.substring(secondDot + 1));
        return this.createToken(jwt, payload);
    }

    public GeronimoJsonWebToken createToken(String jwt, JsonObject payload) {
        return new GeronimoJsonWebToken(jwt, payload);
    }

    private String getAttribute(JsonObject payload, String key, String def) {
        String value;
        JsonString json = payload.getJsonString(key);
        String string = value = json != null ? json.getString() : def;
        if (value == null) {
            throw new JwtException("No " + key + " in JWT", 401);
        }
        return value;
    }

    private JsonObject loadJson(String src) {
        return this.readerFactory.createReader((InputStream)new ByteArrayInputStream(Base64.getUrlDecoder().decode(src))).readObject();
    }
}

