/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.impl.jwtauth.jwt;

import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.Base64;
import java.util.Optional;
import javax.json.JsonObject;

public class JWK {
    private String kid;
    private String kty;
    private String n;
    private String e;
    private String x;
    private String y;
    private String crv;
    private String use;

    public JWK(JsonObject jsonObject) {
        this.kid = jsonObject.getString("kid", null);
        this.kty = jsonObject.getString("kty", null);
        this.x = jsonObject.getString("x", null);
        this.y = jsonObject.getString("y", null);
        this.crv = jsonObject.getString("crv", null);
        this.n = jsonObject.getString("n", null);
        this.e = jsonObject.getString("e", null);
        this.use = jsonObject.getString("use", null);
    }

    public String getKid() {
        return this.kid;
    }

    public String getUse() {
        return this.use;
    }

    public String toPemKey() {
        PublicKey publicKey = this.toPublicKey();
        String base64PublicKey = Base64.getMimeEncoder(64, "\n".getBytes()).encodeToString(publicKey.getEncoded());
        String result = "-----BEGIN PUBLIC KEY-----" + base64PublicKey + "-----END PUBLIC KEY-----";
        return result.replace("\n", "");
    }

    public PublicKey toPublicKey() {
        if ("RSA".equals(this.kty)) {
            return this.toRSAPublicKey();
        }
        if ("EC".equals(this.kty)) {
            return this.toECPublicKey();
        }
        throw new IllegalStateException("Unsupported kty. Only RSA and EC are supported.");
    }

    private PublicKey toRSAPublicKey() {
        Base64.Decoder decoder = Base64.getUrlDecoder();
        BigInteger modulus = Optional.ofNullable(this.n).map(mod -> new BigInteger(1, decoder.decode((String)mod))).orElseThrow(() -> new IllegalStateException("n must be set for RSA keys."));
        BigInteger exponent = Optional.ofNullable(this.e).map(exp -> new BigInteger(1, decoder.decode((String)exp))).orElseThrow(() -> new IllegalStateException("e must be set for RSA keys."));
        RSAPublicKeySpec spec = new RSAPublicKeySpec(modulus, exponent);
        try {
            KeyFactory factory = KeyFactory.getInstance("RSA");
            return factory.generatePublic(spec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new IllegalStateException(e);
        }
    }

    private PublicKey toECPublicKey() {
        Base64.Decoder decoder = Base64.getUrlDecoder();
        BigInteger pointX = Optional.ofNullable(this.x).map(x -> new BigInteger(1, decoder.decode((String)x))).orElseThrow(() -> new IllegalStateException("x must be set for EC keys."));
        BigInteger pointY = Optional.ofNullable(this.y).map(y -> new BigInteger(1, decoder.decode((String)y))).orElseThrow(() -> new IllegalStateException("y must be set for EC keys."));
        ECPoint pubPoint = new ECPoint(pointX, pointY);
        try {
            AlgorithmParameters parameters = AlgorithmParameters.getInstance("EC");
            parameters.init(Optional.ofNullable(this.crv).map(JWK::mapCrv).map(ECGenParameterSpec::new).orElseThrow(() -> new IllegalStateException("crv must be set for EC keys.")));
            ECParameterSpec ecParameters = parameters.getParameterSpec(ECParameterSpec.class);
            return KeyFactory.getInstance("EC").generatePublic(new ECPublicKeySpec(pubPoint, ecParameters));
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException | InvalidParameterSpecException e) {
            throw new IllegalStateException(e);
        }
    }

    private static String mapCrv(String crv) {
        if (crv.endsWith("256")) {
            return "secp256r1";
        }
        if (crv.endsWith("384")) {
            return "secp384r1";
        }
        return "secp521r1";
    }
}

