/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.impl.jwtauth.jwt;

import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import org.apache.geronimo.microprofile.impl.jwtauth.JwtException;
import org.apache.geronimo.microprofile.impl.jwtauth.config.GeronimoJwtAuthConfig;
import org.eclipse.microprofile.jwt.Claims;

@ApplicationScoped
public class DateValidator {
    @Inject
    private GeronimoJwtAuthConfig config;
    private boolean expirationMandatory;
    private boolean issuedAtTimeMandatory;
    private long tolerance;

    @PostConstruct
    private void init() {
        this.expirationMandatory = Boolean.parseBoolean(this.config.read("exp.required", "true"));
        this.issuedAtTimeMandatory = Boolean.parseBoolean(this.config.read("iat.required", "true"));
        this.tolerance = Long.parseLong(this.config.read("date.tolerance", Long.toString(Optional.ofNullable(this.config.read("org.eclipse.microprofile.authentication.JWT.clockSkew", null)).map(Long::parseLong).orElse(60L))));
    }

    public void checkInterval(JsonObject payload) {
        JsonNumber iat;
        long now = -1L;
        JsonNumber exp = payload.getJsonNumber(Claims.exp.name());
        if (exp == null) {
            if (this.expirationMandatory) {
                throw new JwtException("No exp in the JWT", 401);
            }
        } else {
            long expValue = exp.longValue();
            if (expValue < (now = this.now()) - this.tolerance) {
                throw new JwtException("Token expired", 401);
            }
        }
        if ((iat = payload.getJsonNumber(Claims.iat.name())) == null) {
            if (this.issuedAtTimeMandatory) {
                throw new JwtException("No iat in the JWT", 401);
            }
        } else {
            long iatValue = iat.longValue();
            if (now < 0L) {
                now = this.now();
            }
            if (iatValue > now + this.tolerance) {
                throw new JwtException("Token issued after current time", 401);
            }
        }
    }

    private long now() {
        return System.currentTimeMillis() / 1000L;
    }
}

