/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.impl.jwtauth.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.enterprise.inject.Vetoed;
import org.apache.geronimo.microprofile.impl.jwtauth.config.GeronimoJwtAuthConfig;

@Vetoed
class DefaultJwtAuthConfig
implements GeronimoJwtAuthConfig {
    private final Map<String, String> configuration = new HashMap<String, String>();

    DefaultJwtAuthConfig() {
        System.getProperties().stringPropertyNames().forEach(k -> this.configuration.put((String)k, System.getProperty(k)));
        try (InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream("META-INF/geronimo/microprofile/jwt-auth.properties");){
            if (stream != null) {
                Properties properties = new Properties();
                properties.load(stream);
                properties.stringPropertyNames().forEach(k -> this.configuration.put((String)k, properties.getProperty((String)k)));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String read(String value, String def) {
        return this.configuration.getOrDefault(value, def);
    }
}

