/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.domain.RegionInformation;
import org.apache.geode.management.internal.cli.functions.GetRegionsFunction;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.management.internal.util.ManagementUtils;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class ListRegionCommand
extends GfshCommand {
    @Immutable
    private static final GetRegionsFunction getRegionsFunction = new GetRegionsFunction();

    @CliCommand(value={"list regions"}, help="Display regions of a member or members.")
    @CliMetaData(relatedTopic={"Region"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public ResultModel listRegion(@CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups:disable-string-converter", help="Group of members for which regions will be displayed.") String[] group, @CliOption(key={"member", "members"}, optionContext="geode.converter.member.idOrName:disable-string-converter", help="Name/Id of the member for which regions will be displayed.") String[] memberNameOrId) {
        ResultModel result = new ResultModel();
        Set<DistributedMember> targetMembers = this.findMembers(group, memberNameOrId);
        if (targetMembers.isEmpty()) {
            return ResultModel.createInfo("No Members Found");
        }
        TabularResultModel resultData = result.addTable("regionInfo");
        ResultCollector rc = ManagementUtils.executeFunction((Function)getRegionsFunction, null, targetMembers);
        ArrayList resultList = (ArrayList)rc.getResult();
        if (resultList != null) {
            LinkedHashSet regionInfoSet = new LinkedHashSet(resultList.stream().filter(Objects::nonNull).filter(Object[].class::isInstance).map(Object[].class::cast).flatMap(Arrays::stream).filter(RegionInformation.class::isInstance).map(RegionInformation.class::cast).collect(Collectors.toSet()));
            TreeSet<String> regionNames = new TreeSet<String>();
            for (RegionInformation regionInfo : regionInfoSet) {
                regionNames.add(regionInfo.getName());
                Set<String> subRegionNames = regionInfo.getSubRegionNames();
                regionNames.addAll(subRegionNames);
            }
            if (regionNames.isEmpty()) {
                return ResultModel.createInfo("No Regions Found");
            }
            for (String regionName : regionNames) {
                resultData.accumulate("List of regions", regionName);
            }
        }
        return result;
    }
}

