/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.api.observer;

import java.util.function.BiConsumer;
import org.apache.fluo.api.config.SimpleConfiguration;
import org.apache.fluo.api.data.Column;
import org.apache.fluo.api.metrics.MetricsReporter;
import org.apache.fluo.api.observer.ColumnProviderRegistry;
import org.apache.fluo.api.observer.Observer;
import org.apache.fluo.api.observer.StringObserver;

public interface ObserverProvider {
    public void provide(Registry var1, Context var2);

    default public void provideColumns(final BiConsumer<Column, Observer.NotificationType> colRegistry, Context ctx) {
        Registry or = new Registry(){

            @Override
            public Registry.IdentityOption forColumn(Column observedColumn, Observer.NotificationType ntfyType) {
                return new ColumnProviderRegistry(observedColumn, ntfyType, colRegistry);
            }
        };
        this.provide(or, ctx);
    }

    public static interface Registry {
        public IdentityOption forColumn(Column var1, Observer.NotificationType var2);

        public static interface IdentityOption
        extends ObserverArgument {
            public ObserverArgument withId(String var1);
        }

        public static interface ObserverArgument {
            public void useObserver(Observer var1);

            public void useStrObserver(StringObserver var1);
        }
    }

    public static interface Context {
        public SimpleConfiguration getAppConfiguration();

        public MetricsReporter getMetricsReporter();
    }
}

