/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.api.data;

import java.io.Serializable;
import java.util.Objects;
import org.apache.fluo.api.data.Bytes;
import org.apache.fluo.api.data.Column;
import org.apache.fluo.api.data.RowColumn;

public final class RowColumnValue
implements Comparable<RowColumnValue>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Bytes row = Bytes.EMPTY;
    private Column col = Column.EMPTY;
    private Bytes val = Bytes.EMPTY;
    private int hashCode = 0;

    public RowColumnValue(Bytes row, Column col, Bytes val) {
        this.row = row;
        this.col = col;
        this.val = val;
    }

    public RowColumnValue(CharSequence row, Column col, CharSequence val) {
        this.row = Bytes.of(row);
        this.col = col;
        this.val = Bytes.of(val);
    }

    public Bytes getRow() {
        return this.row;
    }

    public String getsRow() {
        return this.row.toString();
    }

    public Column getColumn() {
        return this.col;
    }

    public Bytes getValue() {
        return this.val;
    }

    public String getsValue() {
        return this.val.toString();
    }

    public RowColumn getRowColumn() {
        return new RowColumn(this.row, this.col);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(this.row, this.col, this.val);
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RowColumnValue) {
            RowColumnValue orcv = (RowColumnValue)o;
            return this.row.equals(orcv.row) && this.col.equals(orcv.col) && this.val.equals(orcv.val);
        }
        return false;
    }

    public String toString() {
        return this.getRowColumn() + " " + this.val;
    }

    @Override
    public int compareTo(RowColumnValue o) {
        if (this == o) {
            return 0;
        }
        int result = this.row.compareTo(o.row);
        if (result == 0 && (result = this.col.compareTo(o.col)) == 0) {
            result = this.val.compareTo(o.val);
        }
        return result;
    }
}

