/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.api.data;

import java.io.Serializable;
import java.util.Objects;
import org.apache.fluo.api.data.Bytes;
import org.apache.fluo.api.data.Column;

public final class RowColumn
implements Comparable<RowColumn>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static RowColumn EMPTY = new RowColumn();
    private Bytes row = Bytes.EMPTY;
    private Column col = Column.EMPTY;
    private int hashCode = 0;

    public RowColumn() {
    }

    public RowColumn(Bytes row) {
        Objects.requireNonNull(row, "Row must not be null");
        this.row = row;
    }

    public RowColumn(CharSequence row) {
        this(Bytes.of(row));
    }

    public RowColumn(Bytes row, Column col) {
        Objects.requireNonNull(row, "Row must not be null");
        Objects.requireNonNull(col, "Col must not be null");
        this.row = row;
        this.col = col;
    }

    public RowColumn(CharSequence row, Column col) {
        this(Bytes.of(row), col);
    }

    public Bytes getRow() {
        return this.row;
    }

    public String getsRow() {
        return this.row.toString();
    }

    public Column getColumn() {
        return this.col;
    }

    public String toString() {
        return this.row + " " + this.col;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof RowColumn) {
            RowColumn other = (RowColumn)o;
            return this.row.equals(other.row) && this.col.equals(other.col);
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(this.row, this.col);
        }
        return this.hashCode;
    }

    public RowColumn following() {
        if (this.row.equals(Bytes.EMPTY)) {
            return EMPTY;
        }
        if (this.col.equals(Column.EMPTY)) {
            return new RowColumn(this.followingBytes(this.row));
        }
        if (!this.col.isQualifierSet()) {
            return new RowColumn(this.row, new Column(this.followingBytes(this.col.getFamily())));
        }
        if (!this.col.isVisibilitySet()) {
            return new RowColumn(this.row, new Column(this.col.getFamily(), this.followingBytes(this.col.getQualifier())));
        }
        return new RowColumn(this.row, new Column(this.col.getFamily(), this.col.getQualifier(), this.followingBytes(this.col.getVisibility())));
    }

    private byte[] followingArray(byte[] ba) {
        byte[] fba = new byte[ba.length + 1];
        System.arraycopy(ba, 0, fba, 0, ba.length);
        fba[ba.length] = 0;
        return fba;
    }

    private Bytes followingBytes(Bytes b) {
        return Bytes.of(this.followingArray(b.toArray()));
    }

    @Override
    public int compareTo(RowColumn other) {
        if (this == other) {
            return 0;
        }
        int result = this.row.compareTo(other.row);
        if (result == 0) {
            result = this.col.compareTo(other.col);
        }
        return result;
    }
}

