/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.api.data;

import java.io.Serializable;
import java.util.Objects;
import org.apache.fluo.api.data.Bytes;
import org.apache.fluo.api.data.Column;

public final class ColumnValue
implements Serializable,
Comparable<ColumnValue> {
    private static final long serialVersionUID = 1L;
    private Column column;
    private Bytes val;
    private int hashCode = 0;

    public ColumnValue(Column col, Bytes val) {
        this.column = col;
        this.val = val;
    }

    public ColumnValue(Column col, CharSequence val) {
        this.column = col;
        this.val = Bytes.of(val);
    }

    public Column getColumn() {
        return this.column;
    }

    public Bytes getValue() {
        return this.val;
    }

    public String getsValue() {
        return this.val.toString();
    }

    @Override
    public int compareTo(ColumnValue o) {
        if (this == o) {
            return 0;
        }
        int comp = this.column.compareTo(o.column);
        if (comp == 0) {
            comp = this.val.compareTo(o.val);
        }
        return comp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ColumnValue) {
            ColumnValue ocv = (ColumnValue)o;
            return this.column.equals(ocv.column) && this.val.equals(ocv.val);
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(this.column, this.val);
        }
        return this.hashCode;
    }

    public String toString() {
        return this.column + " " + this.val;
    }
}

