/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.api.data;

import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedBytes;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;

public final class Bytes
implements Comparable<Bytes>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final byte[] data;
    private final int offset;
    private final int length;
    private transient WeakReference<String> utf8String;
    public static final Bytes EMPTY = new Bytes(new byte[0]);
    private int hashCode = 0;

    public Bytes() {
        this.data = Bytes.EMPTY.data;
        this.offset = 0;
        this.length = 0;
    }

    private Bytes(byte[] data) {
        this.data = data;
        this.offset = 0;
        this.length = data.length;
    }

    private Bytes(byte[] data, String utf8String) {
        this.data = data;
        this.offset = 0;
        this.length = data.length;
        this.utf8String = new WeakReference<String>(utf8String);
    }

    private Bytes(byte[] data, int offset, int length) {
        if (offset < 0 || offset > data.length || length < 0 || offset + length > data.length) {
            throw new IndexOutOfBoundsException(" Bad offset and/or length data.length = " + data.length + " offset = " + offset + " length = " + length);
        }
        this.data = data;
        this.offset = offset;
        this.length = length;
    }

    public byte byteAt(int i) {
        if (i < 0) {
            throw new IndexOutOfBoundsException("i < 0, " + i);
        }
        if (i >= this.length) {
            throw new IndexOutOfBoundsException("i >= length, " + i + " >= " + this.length);
        }
        return this.data[this.offset + i];
    }

    public int length() {
        return this.length;
    }

    public Bytes subSequence(int start, int end) {
        if (start > end || start < 0 || end > this.length) {
            throw new IndexOutOfBoundsException("Bad start and/end start = " + start + " end=" + end + " offset=" + this.offset + " length=" + this.length);
        }
        return new Bytes(this.data, this.offset + start, end - start);
    }

    public byte[] toArray() {
        byte[] copy = new byte[this.length];
        System.arraycopy(this.data, this.offset, copy, 0, this.length);
        return copy;
    }

    public String toString() {
        String s;
        if (this.utf8String != null && (s = (String)this.utf8String.get()) != null) {
            return s;
        }
        s = new String(this.data, this.offset, this.length, StandardCharsets.UTF_8);
        this.utf8String = new WeakReference<String>(s);
        return s;
    }

    public ByteBuffer toByteBuffer() {
        return ByteBuffer.wrap(this.data, this.offset, this.length).asReadOnlyBuffer();
    }

    public InputStream toInputStream() {
        return new ByteArrayInputStream(this.data, this.offset, this.length);
    }

    public void writeTo(OutputStream out) throws IOException {
        if (this.length <= 32) {
            int end = this.offset + this.length;
            for (int i = this.offset; i < end; ++i) {
                out.write(this.data[i]);
            }
        } else {
            out.write(this.toArray());
        }
    }

    @Override
    public final int compareTo(Bytes other) {
        if (this == other) {
            return 0;
        }
        return this.compareToUnchecked(other.data, other.offset, other.length);
    }

    @Override
    public int compareTo(byte[] bytes) {
        return this.compareToUnchecked(bytes, 0, bytes.length);
    }

    public int compareTo(byte[] bytes, int offset, int len) {
        Preconditions.checkArgument((offset >= 0 && len >= 0 && offset + len <= bytes.length ? 1 : 0) != 0);
        return this.compareToUnchecked(bytes, offset, len);
    }

    private int compareToUnchecked(byte[] bytes, int offset, int len) {
        if (this.length == this.data.length && len == bytes.length) {
            return UnsignedBytes.lexicographicalComparator().compare(this.data, bytes);
        }
        int minLen = Math.min(this.length, len);
        int i = this.offset;
        int j = offset;
        while (i < minLen) {
            int a = this.data[i] & 0xFF;
            int b = bytes[j] & 0xFF;
            if (a != b) {
                return a - b;
            }
            ++i;
            ++j;
        }
        return this.length - len;
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Bytes) {
            Bytes ob = (Bytes)other;
            return this.contentEqualsUnchecked(ob.data, ob.offset, ob.length);
        }
        return false;
    }

    public boolean contentEquals(byte[] bytes) {
        return this.contentEqualsUnchecked(bytes, 0, bytes.length);
    }

    public boolean contentEquals(byte[] bytes, int offset, int len) {
        Preconditions.checkArgument((len >= 0 && offset >= 0 && offset + len <= bytes.length ? 1 : 0) != 0);
        return this.contentEqualsUnchecked(bytes, offset, len);
    }

    private boolean contentEqualsUnchecked(byte[] bytes, int offset, int len) {
        if (this.length != len) {
            return false;
        }
        return this.compareToUnchecked(bytes, offset, len) == 0;
    }

    public final int hashCode() {
        if (this.hashCode == 0) {
            int hash = 1;
            int end = this.offset + this.length;
            for (int i = this.offset; i < end; ++i) {
                hash = 31 * hash + this.data[i];
            }
            this.hashCode = hash;
        }
        return this.hashCode;
    }

    public static final Bytes of(byte[] array) {
        Objects.requireNonNull(array);
        if (array.length == 0) {
            return EMPTY;
        }
        byte[] copy = new byte[array.length];
        System.arraycopy(array, 0, copy, 0, array.length);
        return new Bytes(copy);
    }

    public static final Bytes of(byte[] data, int offset, int length) {
        Objects.requireNonNull(data);
        if (length == 0) {
            return EMPTY;
        }
        byte[] copy = new byte[length];
        System.arraycopy(data, offset, copy, 0, length);
        return new Bytes(copy);
    }

    public static final Bytes of(ByteBuffer bb) {
        byte[] data;
        Objects.requireNonNull(bb);
        if (bb.remaining() == 0) {
            return EMPTY;
        }
        if (bb.hasArray()) {
            data = Arrays.copyOfRange(bb.array(), bb.position() + bb.arrayOffset(), bb.limit() + bb.arrayOffset());
        } else {
            data = new byte[bb.remaining()];
            bb.duplicate().get(data);
        }
        return new Bytes(data);
    }

    public static final Bytes of(CharSequence cs) {
        if (cs instanceof String) {
            return Bytes.of((String)cs);
        }
        Objects.requireNonNull(cs);
        if (cs.length() == 0) {
            return EMPTY;
        }
        ByteBuffer bb = StandardCharsets.UTF_8.encode(CharBuffer.wrap(cs));
        if (bb.hasArray()) {
            return new Bytes(bb.array(), bb.position() + bb.arrayOffset(), bb.limit());
        }
        byte[] data = new byte[bb.remaining()];
        bb.get(data);
        return new Bytes(data);
    }

    public static final Bytes of(String s) {
        Objects.requireNonNull(s);
        if (s.length() == 0) {
            return EMPTY;
        }
        byte[] data = s.getBytes(StandardCharsets.UTF_8);
        return new Bytes(data, s);
    }

    public static final Bytes of(String s, Charset c) {
        Objects.requireNonNull(s);
        Objects.requireNonNull(c);
        if (s.length() == 0) {
            return EMPTY;
        }
        byte[] data = s.getBytes(c);
        return new Bytes(data);
    }

    public boolean startsWith(Bytes prefix) {
        Objects.requireNonNull(prefix, "startWith(Bytes prefix) cannot have null parameter");
        if (prefix.length > this.length) {
            return false;
        }
        int end = this.offset + prefix.length;
        int i = this.offset;
        int j = prefix.offset;
        while (i < end) {
            if (this.data[i] != prefix.data[j]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public boolean endsWith(Bytes suffix) {
        Objects.requireNonNull(suffix, "endsWith(Bytes suffix) cannot have null parameter");
        int startOffset = this.length - suffix.length;
        if (startOffset < 0) {
            return false;
        }
        int end = startOffset + this.offset + suffix.length;
        int i = startOffset + this.offset;
        int j = suffix.offset;
        while (i < end) {
            if (this.data[i] != suffix.data[j]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static BytesBuilder builder() {
        return new BytesBuilder();
    }

    public static BytesBuilder builder(int initialCapacity) {
        return new BytesBuilder(initialCapacity);
    }

    public void copyTo(byte[] dest, int destPos) {
        this.arraycopy(0, dest, destPos, this.length);
    }

    public void copyTo(int start, int end, byte[] dest, int destPos) {
        this.arraycopy(start, dest, destPos, end - start);
    }

    private void arraycopy(int start, byte[] dest, int destPos, int length) {
        System.arraycopy(this.data, start + this.offset, dest, destPos, length);
    }

    public static class BytesBuilder {
        private byte[] ba;
        private int len;

        BytesBuilder(int initialCapacity) {
            this.ba = new byte[initialCapacity];
            this.len = 0;
        }

        BytesBuilder() {
            this(32);
        }

        private void ensureCapacity(int min) {
            if (this.ba.length < min) {
                int newLen = this.ba.length * 2;
                if (newLen < min) {
                    newLen = min;
                }
                this.ba = Arrays.copyOf(this.ba, newLen);
            }
        }

        public BytesBuilder append(CharSequence cs) {
            if (cs instanceof String) {
                return this.append((String)cs);
            }
            ByteBuffer bb = StandardCharsets.UTF_8.encode(CharBuffer.wrap(cs));
            int length = bb.remaining();
            this.ensureCapacity(this.len + length);
            bb.get(this.ba, this.len, length);
            this.len += length;
            return this;
        }

        public BytesBuilder append(String s) {
            return this.append(s.getBytes(StandardCharsets.UTF_8));
        }

        public BytesBuilder append(Bytes b) {
            this.ensureCapacity(this.len + b.length);
            System.arraycopy(b.data, b.offset, this.ba, this.len, b.length);
            this.len += b.length();
            return this;
        }

        public BytesBuilder append(byte[] bytes) {
            this.ensureCapacity(this.len + bytes.length);
            System.arraycopy(bytes, 0, this.ba, this.len, bytes.length);
            this.len += bytes.length;
            return this;
        }

        public BytesBuilder append(int b) {
            this.ensureCapacity(this.len + 1);
            this.ba[this.len] = (byte)b;
            ++this.len;
            return this;
        }

        public BytesBuilder append(byte[] bytes, int offset, int length) {
            this.ensureCapacity(this.len + length);
            System.arraycopy(bytes, offset, this.ba, this.len, length);
            this.len += length;
            return this;
        }

        public BytesBuilder append(InputStream in, int length) throws IOException {
            this.ensureCapacity(this.len + length);
            new DataInputStream(in).readFully(this.ba, this.len, length);
            this.len += length;
            return this;
        }

        public BytesBuilder append(ByteBuffer bb) {
            int length = bb.remaining();
            this.ensureCapacity(this.len + length);
            bb.duplicate().get(this.ba, this.len, length);
            this.len += length;
            return this;
        }

        public void setLength(int newLen) {
            Preconditions.checkArgument((newLen >= 0 ? 1 : 0) != 0, (Object)("Negative length passed : " + newLen));
            if (newLen > this.ba.length) {
                this.ba = Arrays.copyOf(this.ba, newLen);
            }
            if (newLen > this.len) {
                Arrays.fill(this.ba, this.len, newLen, (byte)0);
            }
            this.len = newLen;
        }

        public int getLength() {
            return this.len;
        }

        public Bytes toBytes() {
            return Bytes.of(this.ba, 0, this.len);
        }
    }
}

