/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.api.config;

import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConfigurationUtils;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.fluo.api.exceptions.FluoException;

public class SimpleConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient Configuration internalConfig;

    private void init() {
        CompositeConfiguration compositeConfig = new CompositeConfiguration();
        compositeConfig.setThrowExceptionOnMissing(true);
        compositeConfig.setDelimiterParsingDisabled(true);
        this.internalConfig = compositeConfig;
    }

    public SimpleConfiguration() {
        this.init();
    }

    private SimpleConfiguration(Configuration subset) {
        this.internalConfig = subset;
    }

    public SimpleConfiguration(File propertiesFile) {
        this();
        this.load(propertiesFile);
    }

    public SimpleConfiguration(InputStream in) {
        this();
        this.load(in);
    }

    public SimpleConfiguration(SimpleConfiguration other) {
        this();
        Iterator iter = other.internalConfig.getKeys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            this.internalConfig.setProperty(key, other.internalConfig.getProperty(key));
        }
    }

    public SimpleConfiguration(Map<String, String> map) {
        this();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.internalConfig.setProperty(entry.getKey(), (Object)entry.getValue());
        }
    }

    public void clear() {
        this.internalConfig.clear();
    }

    public void clearProperty(String key) {
        this.internalConfig.clearProperty(key);
    }

    public boolean containsKey(String key) {
        return this.internalConfig.containsKey(key);
    }

    public boolean getBoolean(String key) {
        return this.internalConfig.getBoolean(key);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.internalConfig.getBoolean(key, defaultValue);
    }

    public int getInt(String key) {
        return this.internalConfig.getInt(key);
    }

    public int getInt(String key, int defaultValue) {
        return this.internalConfig.getInt(key, defaultValue);
    }

    public Iterator<String> getKeys() {
        return this.internalConfig.getKeys();
    }

    public Iterator<String> getKeys(String key) {
        return this.internalConfig.getKeys(key);
    }

    public long getLong(String key) {
        return this.internalConfig.getLong(key);
    }

    public long getLong(String key, long defaultValue) {
        return this.internalConfig.getLong(key, defaultValue);
    }

    public String getRawString(String key) {
        Object val = this.internalConfig.getProperty(key);
        if (val == null) {
            return null;
        }
        return val.toString();
    }

    public String getString(String key) {
        return this.internalConfig.getString(key);
    }

    public String getString(String key, String defaultValue) {
        return this.internalConfig.getString(key, defaultValue);
    }

    public void load(InputStream in) {
        try {
            PropertiesConfiguration config = new PropertiesConfiguration();
            config.setDelimiterParsingDisabled(true);
            config.load(in);
            ((CompositeConfiguration)this.internalConfig).addConfiguration((Configuration)config);
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void load(File file) {
        try {
            PropertiesConfiguration config = new PropertiesConfiguration();
            config.setDelimiterParsingDisabled(true);
            config.load(file);
            ((CompositeConfiguration)this.internalConfig).addConfiguration((Configuration)config);
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void save(File file) {
        PropertiesConfiguration pconf = new PropertiesConfiguration();
        pconf.setDelimiterParsingDisabled(true);
        pconf.append(this.internalConfig);
        try {
            pconf.save(file);
        }
        catch (ConfigurationException e) {
            throw new FluoException(e);
        }
    }

    public void save(OutputStream out) {
        PropertiesConfiguration pconf = new PropertiesConfiguration();
        pconf.setDelimiterParsingDisabled(true);
        pconf.append(this.internalConfig);
        try {
            pconf.save(out);
        }
        catch (ConfigurationException e) {
            throw new FluoException(e);
        }
    }

    public void setProperty(String key, Boolean value) {
        this.internalConfig.setProperty(key, (Object)value);
    }

    public void setProperty(String key, Integer value) {
        this.internalConfig.setProperty(key, (Object)value);
    }

    public void setProperty(String key, Long value) {
        this.internalConfig.setProperty(key, (Object)value);
    }

    public void setProperty(String key, String value) {
        this.internalConfig.setProperty(key, (Object)value);
    }

    public SimpleConfiguration subset(String prefix) {
        return new SimpleConfiguration(this.internalConfig.subset(prefix));
    }

    public SimpleConfiguration orElse(SimpleConfiguration fallback) {
        SimpleConfiguration copy = new SimpleConfiguration(this);
        for (Map.Entry<String, String> entry : fallback.toMap().entrySet()) {
            if (copy.containsKey(entry.getKey())) continue;
            copy.setProperty(entry.getKey(), entry.getValue());
        }
        return copy;
    }

    public int hashCode() {
        return Objects.hashCode(this.toMap().entrySet());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SimpleConfiguration) {
            Map<String, String> th = this.toMap();
            Map<String, String> sc = ((SimpleConfiguration)o).toMap();
            if (th.size() == sc.size()) {
                return th.entrySet().equals(sc.entrySet());
            }
        }
        return false;
    }

    public String toString() {
        return ConfigurationUtils.toString((Configuration)this.internalConfig);
    }

    public Map<String, String> toMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Iterator<String> ki = this.getKeys();
        while (ki.hasNext()) {
            String k = ki.next();
            builder.put((Object)k, (Object)this.getRawString(k));
        }
        return builder.build();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.save(baos);
        byte[] data = baos.toByteArray();
        out.writeInt(data.length);
        out.write(data);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
        int len = in.readInt();
        byte[] data = new byte[len];
        in.readFully(data);
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        this.load(bais);
    }
}

