/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.api.config;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.fluo.api.config.ObserverSpecification;
import org.apache.fluo.api.config.SimpleConfiguration;
import org.apache.fluo.api.observer.ObserverProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FluoConfiguration
extends SimpleConfiguration {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(FluoConfiguration.class);
    public static final String FLUO_PREFIX = "fluo";
    private static final String CLIENT_PREFIX = "fluo.client";
    @Deprecated
    public static final String CLIENT_APPLICATION_NAME_PROP = "fluo.client.application.name";
    @Deprecated
    public static final String CLIENT_ACCUMULO_PASSWORD_PROP = "fluo.client.accumulo.password";
    @Deprecated
    public static final String CLIENT_ACCUMULO_USER_PROP = "fluo.client.accumulo.user";
    @Deprecated
    public static final String CLIENT_ACCUMULO_INSTANCE_PROP = "fluo.client.accumulo.instance";
    @Deprecated
    public static final String CLIENT_ACCUMULO_ZOOKEEPERS_PROP = "fluo.client.accumulo.zookeepers";
    @Deprecated
    public static final String CLIENT_ZOOKEEPER_TIMEOUT_PROP = "fluo.client.zookeeper.timeout";
    @Deprecated
    public static final String CLIENT_ZOOKEEPER_CONNECT_PROP = "fluo.client.zookeeper.connect";
    @Deprecated
    public static final String CLIENT_RETRY_TIMEOUT_MS_PROP = "fluo.client.retry.timeout.ms";
    @Deprecated
    public static final int CLIENT_ZOOKEEPER_TIMEOUT_DEFAULT = 30000;
    @Deprecated
    public static final String CLIENT_ACCUMULO_ZOOKEEPERS_DEFAULT = "localhost";
    @Deprecated
    public static final String CLIENT_ZOOKEEPER_CONNECT_DEFAULT = "localhost/fluo";
    @Deprecated
    public static final int CLIENT_RETRY_TIMEOUT_MS_DEFAULT = -1;
    public static final String CONNECTION_PREFIX = "fluo.connection";
    public static final String CONNECTION_APPLICATION_NAME_PROP = "fluo.connection.application.name";
    public static final String CONNECTION_ZOOKEEPER_TIMEOUT_PROP = "fluo.connection.zookeeper.timeout";
    public static final String CONNECTION_ZOOKEEPER_SECRET = "fluo.connection.zookeeper.secret";
    public static final String CONNECTION_ZOOKEEPERS_PROP = "fluo.connection.zookeepers";
    public static final String CONNECTION_RETRY_TIMEOUT_MS_PROP = "fluo.connection.retry.timeout.ms";
    public static final int CONNECTION_ZOOKEEPER_TIMEOUT_DEFAULT = 30000;
    public static final String CONNECTION_ZOOKEEPERS_DEFAULT = "localhost/fluo";
    public static final int CONNECTION_RETRY_TIMEOUT_MS_DEFAULT = -1;
    private static final String ACCUMULO_PREFIX = "fluo.accumulo";
    public static final String ACCUMULO_INSTANCE_PROP = "fluo.accumulo.instance";
    public static final String ACCUMULO_TABLE_PROP = "fluo.accumulo.table";
    public static final String ACCUMULO_PASSWORD_PROP = "fluo.accumulo.password";
    public static final String ACCUMULO_USER_PROP = "fluo.accumulo.user";
    public static final String ACCUMULO_ZOOKEEPERS_PROP = "fluo.accumulo.zookeepers";
    public static final String ACCUMULO_JARS_PROP = "fluo.accumulo.jars";
    public static final String ACCUMULO_ZOOKEEPERS_DEFAULT = "localhost";
    public static final String ACCUMULO_JARS_DEFAULT = "";
    private static final String DFS_PREFIX = "fluo.dfs";
    public static final String DFS_ROOT_PROP = "fluo.dfs.root";
    public static final String DFS_ROOT_DEFAULT = "";
    private static final String ADMIN_PREFIX = "fluo.admin";
    @Deprecated
    public static final String ADMIN_ACCUMULO_TABLE_PROP = "fluo.admin.accumulo.table";
    @Deprecated
    public static final String ADMIN_ACCUMULO_CLASSPATH_PROP = "fluo.admin.accumulo.classpath";
    @Deprecated
    public static final String ADMIN_ACCUMULO_CLASSPATH_DEFAULT = "";
    private static final String WORKER_PREFIX = "fluo.worker";
    public static final String WORKER_NUM_THREADS_PROP = "fluo.worker.num.threads";
    public static final int WORKER_NUM_THREADS_DEFAULT = 10;
    private static final String LOADER_PREFIX = "fluo.loader";
    public static final String LOADER_NUM_THREADS_PROP = "fluo.loader.num.threads";
    public static final String LOADER_QUEUE_SIZE_PROP = "fluo.loader.queue.size";
    public static final int LOADER_NUM_THREADS_DEFAULT = 10;
    public static final int LOADER_QUEUE_SIZE_DEFAULT = 10;
    private static final String MINI_PREFIX = "fluo.mini";
    public static final String MINI_START_ACCUMULO_PROP = "fluo.mini.start.accumulo";
    public static final String MINI_DATA_DIR_PROP = "fluo.mini.data.dir";
    public static final boolean MINI_START_ACCUMULO_DEFAULT = true;
    public static final String MINI_DATA_DIR_DEFAULT = "${env:FLUO_HOME}/mini";
    public static final String OBSERVER_PREFIX = "fluo.observer.";
    public static final String OBSERVER_PROVIDER = "fluo.observer.provider";
    public static final String OBSERVER_INIT_DIR_PROP = "fluo.observer.init.dir";
    public static final String OBSERVER_JARS_URL_PROP = "fluo.observer.jars.url";
    public static final String OBSERVER_PROVIDER_DEFAULT = "";
    public static final String OBSERVER_INIT_DIR_DEFAULT = "";
    public static final String OBSERVER_JARS_URL_DEFAULT = "";
    public static final String TRANSACTION_PREFIX = "fluo.tx";
    public static final String TRANSACTION_ROLLBACK_TIME_PROP = "fluo.tx.rollback.time";
    public static final long TRANSACTION_ROLLBACK_TIME_DEFAULT = 300000L;
    public static final String REPORTER_PREFIX = "fluo.metrics.reporter";
    public static final String APP_PREFIX = "fluo.app";

    public FluoConfiguration() {
    }

    public FluoConfiguration(SimpleConfiguration other) {
        super(other);
    }

    public FluoConfiguration(InputStream in) {
        super(in);
    }

    public FluoConfiguration(File propertiesFile) {
        super(propertiesFile);
    }

    public FluoConfiguration(Map<String, String> map) {
        super(map);
    }

    public void validate() {
        this.getAccumuloInstance();
        this.getAccumuloPassword();
        this.getAccumuloTable();
        this.getAccumuloUser();
        this.getAccumuloZookeepers();
        this.getApplicationName();
        this.getAppZookeepers();
        this.getConnectionRetryTimeout();
        this.getLoaderQueueSize();
        this.getLoaderThreads();
        this.getObserverSpecifications();
        this.getTransactionRollbackTime();
        this.getWorkerThreads();
        this.getZookeeperTimeout();
    }

    public FluoConfiguration setApplicationName(String applicationName) {
        this.verifyApplicationName(applicationName);
        this.setProperty(CONNECTION_APPLICATION_NAME_PROP, applicationName);
        return this;
    }

    public String getApplicationName() {
        String applicationName;
        if (this.containsKey(CONNECTION_APPLICATION_NAME_PROP)) {
            applicationName = this.getString(CONNECTION_APPLICATION_NAME_PROP);
        } else if (this.containsKey(CLIENT_APPLICATION_NAME_PROP)) {
            applicationName = this.getString(CLIENT_APPLICATION_NAME_PROP);
        } else {
            throw new NoSuchElementException("fluo.connection.application.name was not set");
        }
        this.verifyApplicationName(applicationName);
        return applicationName;
    }

    private void verifyApplicationName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Application name cannot be null");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("Application name length must be > 0");
        }
        String reason = null;
        char[] chars = name.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '\u0000') {
                reason = "null character not allowed @" + i;
                break;
            }
            if (c == '/' || c == '.' || c == ':') {
                reason = "invalid character '" + c + "'";
                break;
            }
            if (!(c > '\u0000' && c <= '\u001f' || c >= '\u007f' && c <= '\u009f' || c >= '\ud800' && c <= '\uf8ff') && (c < '\ufff0' || c > '\uffff')) continue;
            reason = "invalid character @" + i;
            break;
        }
        if (reason != null) {
            throw new IllegalArgumentException("Invalid application name \"" + name + "\" caused by " + reason);
        }
    }

    public FluoConfiguration setInstanceZookeepers(String zookeepers) {
        return this.setNonEmptyString(CONNECTION_ZOOKEEPERS_PROP, zookeepers);
    }

    public String getInstanceZookeepers() {
        return this.getDepNonEmptyString(CONNECTION_ZOOKEEPERS_PROP, CLIENT_ZOOKEEPER_CONNECT_PROP, "localhost/fluo");
    }

    public String getAppZookeepers() {
        return this.getInstanceZookeepers() + "/" + this.getApplicationName();
    }

    public FluoConfiguration setZookeeperTimeout(int timeout) {
        return this.setPositiveInt(CONNECTION_ZOOKEEPER_TIMEOUT_PROP, timeout);
    }

    public int getZookeeperTimeout() {
        return this.getDepPositiveInt(CONNECTION_ZOOKEEPER_TIMEOUT_PROP, CLIENT_ZOOKEEPER_TIMEOUT_PROP, 30000);
    }

    public String getZookeeperSecret() {
        return this.getString(CONNECTION_ZOOKEEPER_SECRET, "");
    }

    public void setZookeeperSecret(String secret) {
        this.setProperty(CONNECTION_ZOOKEEPER_SECRET, FluoConfiguration.verifyNotNull(CONNECTION_ZOOKEEPER_SECRET, secret));
    }

    @Deprecated
    public FluoConfiguration setClientRetryTimeout(int timeoutMs) {
        return this.setConnectionRetryTimeout(timeoutMs);
    }

    @Deprecated
    public int getClientRetryTimeout() {
        return this.getConnectionRetryTimeout();
    }

    public FluoConfiguration setConnectionRetryTimeout(int timeoutMS) {
        Preconditions.checkArgument((timeoutMS >= -1 ? 1 : 0) != 0, (Object)"fluo.connection.retry.timeout.ms must be >= -1");
        this.setProperty(CONNECTION_RETRY_TIMEOUT_MS_PROP, timeoutMS);
        return this;
    }

    public int getConnectionRetryTimeout() {
        int retval = this.containsKey(CONNECTION_RETRY_TIMEOUT_MS_PROP) ? this.getInt(CONNECTION_RETRY_TIMEOUT_MS_PROP, -1) : this.getInt(CLIENT_RETRY_TIMEOUT_MS_PROP, -1);
        Preconditions.checkArgument((retval >= -1 ? 1 : 0) != 0, (Object)"fluo.connection.retry.timeout.ms must be >= -1");
        return retval;
    }

    public FluoConfiguration setAccumuloInstance(String accumuloInstance) {
        return this.setNonEmptyString(ACCUMULO_INSTANCE_PROP, accumuloInstance);
    }

    public String getAccumuloInstance() {
        return this.getDepNonEmptyString(ACCUMULO_INSTANCE_PROP, CLIENT_ACCUMULO_INSTANCE_PROP);
    }

    public FluoConfiguration setAccumuloUser(String accumuloUser) {
        return this.setNonEmptyString(ACCUMULO_USER_PROP, accumuloUser);
    }

    public String getAccumuloUser() {
        return this.getDepNonEmptyString(ACCUMULO_USER_PROP, CLIENT_ACCUMULO_USER_PROP);
    }

    public FluoConfiguration setAccumuloPassword(String accumuloPassword) {
        this.setProperty(ACCUMULO_PASSWORD_PROP, FluoConfiguration.verifyNotNull(ACCUMULO_PASSWORD_PROP, accumuloPassword));
        return this;
    }

    public String getAccumuloPassword() {
        if (this.containsKey(ACCUMULO_PASSWORD_PROP)) {
            return FluoConfiguration.verifyNotNull(ACCUMULO_PASSWORD_PROP, this.getString(ACCUMULO_PASSWORD_PROP));
        }
        if (this.containsKey(CLIENT_ACCUMULO_PASSWORD_PROP)) {
            return FluoConfiguration.verifyNotNull(CLIENT_ACCUMULO_PASSWORD_PROP, this.getString(CLIENT_ACCUMULO_PASSWORD_PROP));
        }
        throw new NoSuchElementException("fluo.accumulo.password is not set!");
    }

    public FluoConfiguration setAccumuloZookeepers(String zookeepers) {
        return this.setNonEmptyString(ACCUMULO_ZOOKEEPERS_PROP, zookeepers);
    }

    public String getAccumuloZookeepers() {
        return this.getDepNonEmptyString(ACCUMULO_ZOOKEEPERS_PROP, CLIENT_ACCUMULO_ZOOKEEPERS_PROP, "localhost");
    }

    public FluoConfiguration setAccumuloTable(String table) {
        return this.setNonEmptyString(ACCUMULO_TABLE_PROP, table);
    }

    public String getAccumuloTable() {
        return this.getDepNonEmptyString(ACCUMULO_TABLE_PROP, ADMIN_ACCUMULO_TABLE_PROP);
    }

    @Deprecated
    public FluoConfiguration setAccumuloClasspath(String path) {
        this.setProperty(ADMIN_ACCUMULO_CLASSPATH_PROP, FluoConfiguration.verifyNotNull(ADMIN_ACCUMULO_CLASSPATH_PROP, path));
        return this;
    }

    @Deprecated
    public String getAccumuloClasspath() {
        return this.getString(ADMIN_ACCUMULO_CLASSPATH_PROP, "");
    }

    public FluoConfiguration setAccumuloJars(String path) {
        this.setProperty(ACCUMULO_JARS_PROP, FluoConfiguration.verifyNotNull(ACCUMULO_JARS_PROP, path));
        return this;
    }

    public String getAccumuloJars() {
        return this.getString(ACCUMULO_JARS_PROP, "");
    }

    public FluoConfiguration setDfsRoot(String dfsRoot) {
        return this.setNonEmptyString(DFS_ROOT_PROP, dfsRoot);
    }

    public String getDfsRoot() {
        return this.getString(DFS_ROOT_PROP, "");
    }

    public FluoConfiguration setWorkerThreads(int numThreads) {
        return this.setPositiveInt(WORKER_NUM_THREADS_PROP, numThreads);
    }

    public int getWorkerThreads() {
        return this.getPositiveInt(WORKER_NUM_THREADS_PROP, 10);
    }

    @Deprecated
    public List<ObserverSpecification> getObserverSpecifications() {
        ArrayList<ObserverSpecification> configList = new ArrayList<ObserverSpecification>();
        Iterator<String> iter = this.getKeys();
        while (iter.hasNext()) {
            String key = iter.next();
            if (!key.startsWith(OBSERVER_PREFIX) || key.equals(OBSERVER_PROVIDER) || key.equals(OBSERVER_INIT_DIR_PROP) || key.equals(OBSERVER_JARS_URL_PROP)) continue;
            String value = this.getString(key).trim();
            if (value.isEmpty()) {
                throw new IllegalArgumentException(key + " is set to empty value");
            }
            String[] fields = value.split(",");
            if (fields.length == 0) {
                throw new IllegalArgumentException(key + " has bad value: " + value);
            }
            String className = fields[0];
            if (className.isEmpty()) {
                throw new IllegalArgumentException(key + " has empty class name: " + className);
            }
            HashMap<String, String> params = new HashMap<String, String>();
            for (int i = 1; i < fields.length; ++i) {
                String[] kv = fields[i].split("=");
                if (kv.length != 2) {
                    throw new IllegalArgumentException(key + " has invalid param. Expected 'key=value' but encountered '" + fields[i] + "'");
                }
                if (kv[0].isEmpty() || kv[1].isEmpty()) {
                    throw new IllegalArgumentException(key + " has empty key or value in param: " + fields[i]);
                }
                params.put(kv[0], kv[1]);
            }
            ObserverSpecification observerSpecification = new ObserverSpecification(className, params);
            configList.add(observerSpecification);
        }
        return configList;
    }

    private int getNextObserverId() {
        Iterator<String> iter1 = this.getKeys(OBSERVER_PREFIX.substring(0, OBSERVER_PREFIX.length() - 1));
        int max = -1;
        while (iter1.hasNext()) {
            String key = iter1.next();
            String suffix = key.substring(OBSERVER_PREFIX.length());
            if (!suffix.matches("\\d+")) continue;
            try {
                max = Math.max(max, Integer.parseInt(suffix));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return max + 1;
    }

    public void setObserverProvider(String className) {
        this.setNonEmptyString(OBSERVER_PROVIDER, className);
    }

    public void setObserverProvider(Class<? extends ObserverProvider> clazz) {
        this.setObserverProvider(clazz.getName());
    }

    public FluoConfiguration setObserverInitDir(String observerDir) {
        this.setProperty(OBSERVER_INIT_DIR_PROP, FluoConfiguration.verifyNotNull(OBSERVER_INIT_DIR_PROP, observerDir));
        return this;
    }

    public String getObserverInitDir() {
        return this.getString(OBSERVER_INIT_DIR_PROP, "");
    }

    public FluoConfiguration setObserverJarsUrl(String observerJarsUrl) {
        this.setProperty(OBSERVER_JARS_URL_PROP, FluoConfiguration.verifyNotNull(OBSERVER_JARS_URL_PROP, observerJarsUrl));
        return this;
    }

    public String getObserverJarsUrl() {
        return this.getString(OBSERVER_JARS_URL_PROP, "");
    }

    public String getObserverProvider() {
        return this.getString(OBSERVER_PROVIDER, "");
    }

    @Deprecated
    private void addObserver(ObserverSpecification oconf, int next) {
        Map<String, String> params = oconf.getConfiguration().toMap();
        StringBuilder paramString = new StringBuilder();
        for (Map.Entry<String, String> pentry : params.entrySet()) {
            paramString.append(',');
            paramString.append(pentry.getKey());
            paramString.append('=');
            paramString.append(pentry.getValue());
        }
        this.setProperty(OBSERVER_PREFIX + next, oconf.getClassName() + paramString);
    }

    @Deprecated
    public FluoConfiguration addObserver(ObserverSpecification oconf) {
        int next = this.getNextObserverId();
        this.addObserver(oconf, next);
        return this;
    }

    @Deprecated
    public FluoConfiguration addObservers(Iterable<ObserverSpecification> observers) {
        int next = this.getNextObserverId();
        for (ObserverSpecification oconf : observers) {
            this.addObserver(oconf, next++);
        }
        return this;
    }

    @Deprecated
    public FluoConfiguration clearObservers() {
        Iterator<String> iter1 = this.getKeys(OBSERVER_PREFIX.substring(0, OBSERVER_PREFIX.length() - 1));
        while (iter1.hasNext()) {
            String key = iter1.next();
            this.clearProperty(key);
        }
        return this;
    }

    public FluoConfiguration setTransactionRollbackTime(long time, TimeUnit tu) {
        return this.setPositiveLong(TRANSACTION_ROLLBACK_TIME_PROP, tu.toMillis(time));
    }

    public long getTransactionRollbackTime() {
        return this.getPositiveLong(TRANSACTION_ROLLBACK_TIME_PROP, 300000L);
    }

    public FluoConfiguration setLoaderThreads(int numThreads) {
        return this.setNonNegativeInt(LOADER_NUM_THREADS_PROP, numThreads);
    }

    public int getLoaderThreads() {
        return this.getNonNegativeInt(LOADER_NUM_THREADS_PROP, 10);
    }

    public FluoConfiguration setLoaderQueueSize(int queueSize) {
        return this.setNonNegativeInt(LOADER_QUEUE_SIZE_PROP, queueSize);
    }

    public int getLoaderQueueSize() {
        return this.getNonNegativeInt(LOADER_QUEUE_SIZE_PROP, 10);
    }

    public SimpleConfiguration getReporterConfiguration(String reporter) {
        return this.subset("fluo.metrics.reporter." + reporter);
    }

    public SimpleConfiguration getAppConfiguration() {
        return this.subset(APP_PREFIX);
    }

    public FluoConfiguration setMiniStartAccumulo(boolean startAccumulo) {
        this.setProperty(MINI_START_ACCUMULO_PROP, startAccumulo);
        return this;
    }

    public boolean getMiniStartAccumulo() {
        return this.getBoolean(MINI_START_ACCUMULO_PROP, true);
    }

    public FluoConfiguration setMiniDataDir(String dataDir) {
        return this.setNonEmptyString(MINI_DATA_DIR_PROP, dataDir);
    }

    public String getMiniDataDir() {
        return this.getNonEmptyString(MINI_DATA_DIR_PROP, MINI_DATA_DIR_DEFAULT);
    }

    public void print() {
        Iterator<String> iter = this.getKeys();
        while (iter.hasNext()) {
            String key = iter.next();
            log.info(key + " = " + this.getRawString(key));
        }
    }

    private boolean verifyStringPropSet(String ... keys) {
        for (String key : keys) {
            if (!this.containsKey(key) || this.getString(key).isEmpty()) continue;
            return true;
        }
        log.info(keys[0] + " is not set");
        return false;
    }

    private boolean verifyStringPropNotSet(String ... keys) {
        for (String key : keys) {
            if (!this.containsKey(key) || this.getString(key).isEmpty()) continue;
            log.info(key + " should not be set");
            return false;
        }
        return true;
    }

    public boolean hasRequiredConnectionProps() {
        boolean valid = true;
        return valid &= this.verifyStringPropSet(CONNECTION_APPLICATION_NAME_PROP, CLIENT_APPLICATION_NAME_PROP);
    }

    public boolean hasRequiredClientProps() {
        boolean valid = true;
        valid &= this.verifyStringPropSet(CONNECTION_APPLICATION_NAME_PROP, CLIENT_APPLICATION_NAME_PROP);
        valid &= this.verifyStringPropSet(ACCUMULO_USER_PROP, CLIENT_ACCUMULO_USER_PROP);
        valid &= this.verifyStringPropSet(ACCUMULO_PASSWORD_PROP, CLIENT_ACCUMULO_PASSWORD_PROP);
        return valid &= this.verifyStringPropSet(ACCUMULO_INSTANCE_PROP, CLIENT_ACCUMULO_INSTANCE_PROP);
    }

    public boolean hasRequiredAdminProps() {
        boolean valid = true;
        valid &= this.hasRequiredClientProps();
        return valid &= this.verifyStringPropSet(ACCUMULO_TABLE_PROP, ADMIN_ACCUMULO_TABLE_PROP);
    }

    public boolean hasRequiredOracleProps() {
        boolean valid = true;
        return valid &= this.hasRequiredClientProps();
    }

    public boolean hasRequiredWorkerProps() {
        boolean valid = true;
        return valid &= this.hasRequiredClientProps();
    }

    public boolean hasRequiredMiniFluoProps() {
        boolean valid = true;
        if (this.getMiniStartAccumulo()) {
            valid &= this.verifyStringPropNotSet(ACCUMULO_USER_PROP, CLIENT_ACCUMULO_USER_PROP);
            valid &= this.verifyStringPropNotSet(ACCUMULO_PASSWORD_PROP, CLIENT_ACCUMULO_PASSWORD_PROP);
            valid &= this.verifyStringPropNotSet(ACCUMULO_INSTANCE_PROP, CLIENT_ACCUMULO_INSTANCE_PROP);
            valid &= this.verifyStringPropNotSet(ACCUMULO_ZOOKEEPERS_PROP, CLIENT_ACCUMULO_ZOOKEEPERS_PROP);
            if (!(valid &= this.verifyStringPropNotSet(CONNECTION_ZOOKEEPERS_PROP, CLIENT_ZOOKEEPER_CONNECT_PROP))) {
                log.error("Client properties should not be set in your configuration if MiniFluo is configured to start its own accumulo (indicated by fluo.mini.start.accumulo being set to true)");
            }
        } else {
            valid &= this.hasRequiredClientProps();
            valid &= this.hasRequiredAdminProps();
            valid &= this.hasRequiredOracleProps();
            valid &= this.hasRequiredWorkerProps();
        }
        return valid;
    }

    public SimpleConfiguration getClientConfiguration() {
        SimpleConfiguration clientConfig = new SimpleConfiguration();
        Iterator<String> iter = this.getKeys();
        while (iter.hasNext()) {
            String key = iter.next();
            if (!key.startsWith(CONNECTION_PREFIX) && !key.startsWith(ACCUMULO_PREFIX) && !key.startsWith(CLIENT_PREFIX)) continue;
            clientConfig.setProperty(key, this.getRawString(key));
        }
        return clientConfig;
    }

    public static SimpleConfiguration getDefaultConfiguration() {
        SimpleConfiguration config = new SimpleConfiguration();
        FluoConfiguration.setDefaultConfiguration(config);
        return config;
    }

    public static void setDefaultConfiguration(SimpleConfiguration config) {
        config.setProperty(CONNECTION_ZOOKEEPERS_PROP, "localhost/fluo");
        config.setProperty(CONNECTION_ZOOKEEPER_TIMEOUT_PROP, 30000);
        config.setProperty(DFS_ROOT_PROP, "");
        config.setProperty(ACCUMULO_ZOOKEEPERS_PROP, "localhost");
        config.setProperty(WORKER_NUM_THREADS_PROP, 10);
        config.setProperty(TRANSACTION_ROLLBACK_TIME_PROP, 300000L);
        config.setProperty(LOADER_NUM_THREADS_PROP, 10);
        config.setProperty(LOADER_QUEUE_SIZE_PROP, 10);
        config.setProperty(MINI_START_ACCUMULO_PROP, true);
        config.setProperty(MINI_DATA_DIR_PROP, MINI_DATA_DIR_DEFAULT);
    }

    private FluoConfiguration setNonNegativeInt(String property, int value) {
        Preconditions.checkArgument((value >= 0 ? 1 : 0) != 0, (Object)(property + " must be non-negative"));
        this.setProperty(property, value);
        return this;
    }

    private int getNonNegativeInt(String property, int defaultValue) {
        int value = this.getInt(property, defaultValue);
        Preconditions.checkArgument((value >= 0 ? 1 : 0) != 0, (Object)(property + " must be non-negative"));
        return value;
    }

    private FluoConfiguration setPositiveInt(String property, int value) {
        Preconditions.checkArgument((value > 0 ? 1 : 0) != 0, (Object)(property + " must be positive"));
        this.setProperty(property, value);
        return this;
    }

    private int getPositiveInt(String property, int defaultValue) {
        int value = this.getInt(property, defaultValue);
        Preconditions.checkArgument((value > 0 ? 1 : 0) != 0, (Object)(property + " must be positive"));
        return value;
    }

    private int getDepPositiveInt(String property, String depProperty, int defaultValue) {
        if (this.containsKey(property)) {
            return this.getInt(property, defaultValue);
        }
        return this.getInt(depProperty, defaultValue);
    }

    private FluoConfiguration setPositiveLong(String property, long value) {
        Preconditions.checkArgument((value > 0L ? 1 : 0) != 0, (Object)(property + " must be positive"));
        this.setProperty(property, value);
        return this;
    }

    private long getPositiveLong(String property, long defaultValue) {
        long value = this.getLong(property, defaultValue);
        Preconditions.checkArgument((value > 0L ? 1 : 0) != 0, (Object)(property + " must be positive"));
        return value;
    }

    private FluoConfiguration setNonEmptyString(String property, String value) {
        Objects.requireNonNull(value, property + " cannot be null");
        Preconditions.checkArgument((!value.isEmpty() ? 1 : 0) != 0, (Object)(property + " cannot be empty"));
        this.setProperty(property, value);
        return this;
    }

    private String getNonEmptyString(String property, String defaultValue) {
        String value = this.getString(property, defaultValue);
        Objects.requireNonNull(value, property + " cannot be null");
        Preconditions.checkArgument((!value.isEmpty() ? 1 : 0) != 0, (Object)(property + " cannot be empty"));
        return value;
    }

    private String getNonEmptyString(String property) {
        String value = this.getString(property);
        Objects.requireNonNull(value, property + " cannot be null");
        Preconditions.checkArgument((!value.isEmpty() ? 1 : 0) != 0, (Object)(property + " cannot be empty"));
        return value;
    }

    private String getDepNonEmptyString(String property, String depProperty, String defaultValue) {
        return this.containsKey(property) ? this.getNonEmptyString(property, defaultValue) : this.getNonEmptyString(depProperty, defaultValue);
    }

    private String getDepNonEmptyString(String property, String depProperty) {
        if (this.containsKey(property)) {
            return this.getNonEmptyString(property);
        }
        if (this.containsKey(depProperty)) {
            return this.getNonEmptyString(depProperty);
        }
        throw new NoSuchElementException(property + " is not set!");
    }

    private static String verifyNotNull(String property, String value) {
        return Objects.requireNonNull(value, property + " cannot be null");
    }
}

