/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.api.client;

import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import org.apache.fluo.api.client.FluoAdmin;
import org.apache.fluo.api.client.FluoClient;
import org.apache.fluo.api.config.FluoConfiguration;
import org.apache.fluo.api.config.SimpleConfiguration;
import org.apache.fluo.api.exceptions.FluoException;
import org.apache.fluo.api.mini.MiniFluo;
import org.apache.fluo.api.service.FluoOracle;
import org.apache.fluo.api.service.FluoWorker;

public class FluoFactory {
    private static final String FLUO_IMPL_PREFIX = "fluo.impl";
    private static final String CLIENT_CLASS_PROP = "fluo.impl.client.class";
    private static final String CLIENT_CLASS_DEFAULT = "org.apache.fluo.core.client.FluoClientImpl";
    private static final String ADMIN_CLASS_PROP = "fluo.impl.admin.class";
    private static final String ADMIN_CLASS_DEFAULT = "org.apache.fluo.core.client.FluoAdminImpl";
    private static final String WORKER_CLASS_PROP = "fluo.impl.worker.class";
    private static final String WORKER_CLASS_DEFAULT = "org.apache.fluo.core.worker.FluoWorkerImpl";
    private static final String ORACLE_CLASS_PROP = "fluo.impl.oracle.class";
    private static final String ORACLE_CLASS_DEFAULT = "org.apache.fluo.core.oracle.FluoOracleImpl";
    private static final String MINI_CLASS_PROP = "fluo.impl.mini.class";
    private static final String MINI_CLASS_DEFAULT = "org.apache.fluo.mini.MiniFluoImpl";

    public static FluoClient newClient(SimpleConfiguration configuration) {
        return (FluoClient)FluoFactory.getAndBuildClassWithConfig(configuration, CLIENT_CLASS_PROP, CLIENT_CLASS_DEFAULT);
    }

    public static FluoAdmin newAdmin(SimpleConfiguration configuration) {
        return (FluoAdmin)FluoFactory.getAndBuildClassWithConfig(configuration, ADMIN_CLASS_PROP, ADMIN_CLASS_DEFAULT);
    }

    public static MiniFluo newMiniFluo(SimpleConfiguration configuration) {
        return (MiniFluo)FluoFactory.getAndBuildClassWithConfig(configuration, MINI_CLASS_PROP, MINI_CLASS_DEFAULT);
    }

    public static FluoOracle newOracle(SimpleConfiguration configuration) {
        return (FluoOracle)FluoFactory.getAndBuildClassWithConfig(configuration, ORACLE_CLASS_PROP, ORACLE_CLASS_DEFAULT);
    }

    public static FluoWorker newWorker(SimpleConfiguration configuration) {
        return (FluoWorker)FluoFactory.getAndBuildClassWithConfig(configuration, WORKER_CLASS_PROP, WORKER_CLASS_DEFAULT);
    }

    private static <T> T getAndBuildClassWithConfig(SimpleConfiguration configuration, String classProp, String classDefault) {
        FluoConfiguration config = new FluoConfiguration(configuration);
        String clazz = config.getString(classProp, classDefault);
        Objects.requireNonNull(clazz, classProp + " cannot be null");
        Preconditions.checkArgument((!clazz.isEmpty() ? 1 : 0) != 0, (Object)(classProp + " cannot be empty"));
        return FluoFactory.buildClassWithConfig(clazz, config);
    }

    private static <T> T buildClassWithConfig(String clazz, FluoConfiguration config) {
        try {
            return (T)Class.forName(clazz).getDeclaredConstructor(FluoConfiguration.class).newInstance(config);
        }
        catch (ClassNotFoundException e) {
            String msg = "Could not find " + clazz + " class which could be caused by fluo-core jar not being on the classpath.";
            throw new FluoException(msg, e);
        }
        catch (InvocationTargetException e) {
            String msg = "Failed to construct " + clazz + " class due to exception";
            throw new FluoException(msg, e);
        }
        catch (Exception e) {
            throw new FluoException(e);
        }
    }
}

