/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.sdk.state;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.flink.statefun.sdk.annotations.ForRuntime;
import org.apache.flink.statefun.sdk.state.Accessor;
import org.apache.flink.statefun.sdk.state.Expiration;

public final class PersistedValue<T> {
    private final String name;
    private final Class<T> type;
    private final Expiration expiration;
    private Accessor<T> accessor;

    private PersistedValue(String name, Class<T> type, Expiration expiration, Accessor<T> accessor) {
        this.name = Objects.requireNonNull(name);
        this.type = Objects.requireNonNull(type);
        this.expiration = Objects.requireNonNull(expiration);
        this.accessor = Objects.requireNonNull(accessor);
    }

    public static <T> PersistedValue<T> of(String name, Class<T> type) {
        return PersistedValue.of(name, type, Expiration.none());
    }

    public static <T> PersistedValue<T> of(String name, Class<T> type, Expiration expiration) {
        return new PersistedValue<T>(name, type, expiration, new NonFaultTolerantAccessor());
    }

    public String name() {
        return this.name;
    }

    public Class<T> type() {
        return this.type;
    }

    public Expiration expiration() {
        return this.expiration;
    }

    public T get() {
        return this.accessor.get();
    }

    public void set(T value) {
        this.accessor.set(value);
    }

    public void clear() {
        this.accessor.clear();
    }

    public T updateAndGet(Function<T, T> update) {
        T current = this.accessor.get();
        T updated = update.apply(current);
        this.accessor.set(updated);
        return updated;
    }

    public T getOrDefault(T orElse) {
        T value = this.accessor.get();
        return value != null ? value : orElse;
    }

    public T getOrDefault(Supplier<T> defaultSupplier) {
        T value = this.accessor.get();
        return value != null ? value : defaultSupplier.get();
    }

    @ForRuntime
    void setAccessor(Accessor<T> newAccessor) {
        Objects.requireNonNull(newAccessor);
        this.accessor = newAccessor;
    }

    public String toString() {
        return String.format("PersistedValue{name=%s, type=%s, expiration=%s}", this.name, this.type.getName(), this.expiration);
    }

    private static final class NonFaultTolerantAccessor<E>
    implements Accessor<E> {
        private E element;

        private NonFaultTolerantAccessor() {
        }

        @Override
        public void set(E element) {
            this.element = element;
        }

        @Override
        public E get() {
            return this.element;
        }

        @Override
        public void clear() {
            this.element = null;
        }
    }
}

