/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.sdk.state;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.flink.statefun.sdk.annotations.ForRuntime;
import org.apache.flink.statefun.sdk.state.AppendingBufferAccessor;
import org.apache.flink.statefun.sdk.state.Expiration;

public final class PersistedAppendingBuffer<E> {
    private final String name;
    private final Class<E> elementType;
    private final Expiration expiration;
    private AppendingBufferAccessor<E> accessor;

    private PersistedAppendingBuffer(String name, Class<E> elementType, Expiration expiration, AppendingBufferAccessor<E> accessor) {
        this.name = Objects.requireNonNull(name);
        this.elementType = Objects.requireNonNull(elementType);
        this.expiration = Objects.requireNonNull(expiration);
        this.accessor = Objects.requireNonNull(accessor);
    }

    public static <E> PersistedAppendingBuffer<E> of(String name, Class<E> elementType) {
        return PersistedAppendingBuffer.of(name, elementType, Expiration.none());
    }

    public static <E> PersistedAppendingBuffer<E> of(String name, Class<E> elementType, Expiration expiration) {
        return new PersistedAppendingBuffer<E>(name, elementType, expiration, new NonFaultTolerantAccessor());
    }

    public String name() {
        return this.name;
    }

    public Class<E> elementType() {
        return this.elementType;
    }

    public Expiration expiration() {
        return this.expiration;
    }

    public void append(@Nonnull E element) {
        this.accessor.append(element);
    }

    public void appendAll(@Nonnull List<E> elements) {
        if (!elements.isEmpty()) {
            this.accessor.appendAll(elements);
        }
    }

    public void replaceWith(@Nonnull List<E> elements) {
        if (!elements.isEmpty()) {
            this.accessor.replaceWith(elements);
        } else {
            this.accessor.clear();
        }
    }

    @Nonnull
    public Iterable<E> view() {
        return new UnmodifiableViewIterable(this.accessor.view());
    }

    public void clear() {
        this.accessor.clear();
    }

    public String toString() {
        return String.format("PersistedAppendingBuffer{name=%s, elementType=%s, expiration=%s}", this.name, this.elementType.getName(), this.expiration);
    }

    @ForRuntime
    void setAccessor(AppendingBufferAccessor<E> newAccessor) {
        this.accessor = Objects.requireNonNull(newAccessor);
    }

    private static final class UnmodifiableViewIterator<E>
    implements Iterator<E> {
        private final Iterator<E> delegate;

        UnmodifiableViewIterator(Iterator<E> delegate) {
            this.delegate = Objects.requireNonNull(delegate);
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public E next() {
            return this.delegate.next();
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException("This is an unmodifiable view.");
        }
    }

    private static final class UnmodifiableViewIterable<E>
    implements Iterable<E> {
        private final Iterable<E> delegate;

        private UnmodifiableViewIterable(Iterable<E> delegate) {
            this.delegate = Objects.requireNonNull(delegate);
        }

        @Override
        public Iterator<E> iterator() {
            return new UnmodifiableViewIterator<E>(this.delegate.iterator());
        }
    }

    private static final class NonFaultTolerantAccessor<E>
    implements AppendingBufferAccessor<E> {
        private List<E> list = new ArrayList();

        private NonFaultTolerantAccessor() {
        }

        @Override
        public void append(@Nonnull E element) {
            this.list.add(element);
        }

        @Override
        public void appendAll(@Nonnull List<E> elements) {
            this.list.addAll(elements);
        }

        @Override
        public void replaceWith(@Nonnull List<E> elements) {
            this.list.clear();
            this.list.addAll(elements);
        }

        @Override
        @Nonnull
        public Iterable<E> view() {
            return this.list;
        }

        @Override
        public void clear() {
            this.list.clear();
        }
    }
}

