/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.sdk.match;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.apache.flink.statefun.sdk.Context;

public final class MatchBinder {
    private final IdentityHashMap<Class<?>, List<Method<Object>>> multiMethods = new IdentityHashMap();
    private final IdentityHashMap<Class<?>, BiConsumer<Context, Object>> noPredicateMethods = new IdentityHashMap();
    private boolean customDefaultAction = false;
    private BiConsumer<Context, Object> defaultAction = MatchBinder::unhandledDefaultAction;

    MatchBinder() {
    }

    public <T> MatchBinder predicate(Class<T> type, BiConsumer<Context, T> action) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(action);
        if (this.noPredicateMethods.containsKey(type)) {
            throw new IllegalStateException("There is already a catch all case for class " + type);
        }
        this.noPredicateMethods.put(type, action);
        return this;
    }

    public <T> MatchBinder predicate(Class<T> type, Predicate<T> predicate, BiConsumer<Context, T> action) {
        List methods = this.multiMethods.computeIfAbsent(type, ignored -> new ArrayList());
        BiConsumer<Context, T> a = action;
        Predicate<T> p = predicate;
        methods.add(new Method<T>(p, a));
        return this;
    }

    public MatchBinder otherwise(BiConsumer<Context, Object> action) {
        if (this.customDefaultAction) {
            throw new IllegalStateException("There can only be one default action");
        }
        this.customDefaultAction = true;
        this.defaultAction = Objects.requireNonNull(action);
        return this;
    }

    void invoke(Context context, Object input) {
        Class<?> type = input.getClass();
        List methods = this.multiMethods.getOrDefault(type, Collections.emptyList());
        for (Method m : methods) {
            if (!m.canApply(input)) continue;
            m.apply(context, input);
            return;
        }
        this.noPredicateMethods.getOrDefault(type, this.defaultAction).accept(context, input);
    }

    private static void unhandledDefaultAction(Context context, Object input) {
        throw new IllegalStateException("Don't know how to handle " + input);
    }

    private static final class Method<T> {
        private final Predicate<T> predicate;
        private final BiConsumer<Context, T> apply;

        Method(Predicate<T> predicate, BiConsumer<Context, T> method) {
            this.predicate = Objects.requireNonNull(predicate);
            this.apply = Objects.requireNonNull(method);
        }

        boolean canApply(T input) {
            return this.predicate.test(input);
        }

        void apply(Context context, T input) {
            this.apply.accept(context, (Context)input);
        }
    }
}

