/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.sdk.io;

import java.io.Serializable;
import java.util.Objects;

public final class IngressIdentifier<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String namespace;
    private final String name;
    private final Class<T> producedType;

    public IngressIdentifier(Class<T> producedType, String namespace, String name) {
        this.namespace = Objects.requireNonNull(namespace);
        this.name = Objects.requireNonNull(name);
        this.producedType = Objects.requireNonNull(producedType);
    }

    public String namespace() {
        return this.namespace;
    }

    public String name() {
        return this.name;
    }

    public Class<T> producedType() {
        return this.producedType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IngressIdentifier that = (IngressIdentifier)o;
        return this.namespace.equals(that.namespace) && this.name.equals(that.name) && this.producedType.equals(that.producedType);
    }

    public int hashCode() {
        int hash = 0;
        hash = 37 * hash + this.namespace.hashCode();
        hash = 37 * hash + this.name.hashCode();
        hash = 37 * hash + this.producedType.hashCode();
        return hash;
    }

    public String toString() {
        return String.format("IngressIdentifier(%s, %s, %s)", this.namespace, this.name, this.producedType);
    }
}

