/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.sdk.io;

import java.io.Serializable;
import java.util.Objects;

public final class EgressIdentifier<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String namespace;
    private final String name;
    private final Class<T> consumedType;

    public EgressIdentifier(String namespace, String name, Class<T> consumedType) {
        this.namespace = Objects.requireNonNull(namespace);
        this.name = Objects.requireNonNull(name);
        this.consumedType = Objects.requireNonNull(consumedType);
    }

    public String namespace() {
        return this.namespace;
    }

    public String name() {
        return this.name;
    }

    public Class<T> consumedType() {
        return this.consumedType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EgressIdentifier egressIdentifier = (EgressIdentifier)o;
        return this.namespace.equals(egressIdentifier.namespace) && this.name.equals(egressIdentifier.name) && this.consumedType.equals(egressIdentifier.consumedType);
    }

    public int hashCode() {
        int hash = 0;
        hash = 37 * hash + this.namespace.hashCode();
        hash = 37 * hash + this.name.hashCode();
        hash = 37 * hash + this.consumedType.hashCode();
        return hash;
    }

    public String toString() {
        return String.format("EgressKey(%s, %s, %s)", this.namespace, this.name, this.consumedType);
    }
}

