/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.sdk.core;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.apache.flink.statefun.sdk.annotations.ForRuntime;

@ForRuntime
public final class OptionalProperty<T> {
    private final T defaultValue;
    private T value;

    public static <T> OptionalProperty<T> withDefault(T defaultValue) {
        Objects.requireNonNull(defaultValue);
        return new OptionalProperty<T>(defaultValue);
    }

    public static <T> OptionalProperty<T> withoutDefault() {
        return new OptionalProperty<Object>(null);
    }

    private OptionalProperty(@Nullable T defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void set(T value) {
        this.value = Objects.requireNonNull(value);
    }

    public T get() {
        if (!this.isSet() && !this.hasDefault()) {
            throw new NoSuchElementException("A value has not been set, and no default value was defined.");
        }
        return this.isSet() ? this.value : this.defaultValue;
    }

    public void overwritePropertiesIfPresent(Properties properties, String key) {
        if (this.isSet() || !properties.containsKey(key) && this.hasDefault()) {
            properties.setProperty(key, this.get().toString());
        }
    }

    public void transformPropertiesIfPresent(Properties properties, String key, BiConsumer<Properties, T> transformer) {
        if (this.isSet() || !properties.containsKey(key) && this.hasDefault()) {
            transformer.accept(properties, (Properties)this.get());
        }
    }

    private boolean hasDefault() {
        return this.defaultValue != null;
    }

    private boolean isSet() {
        return this.value != null;
    }
}

