/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.sdk;

import java.io.Serializable;
import java.util.Objects;

public final class TypeName
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DELIMITER = "/";
    private final String namespace;
    private final String name;
    private final String canonicalTypenameString;

    public static TypeName parseFrom(String typeNameString) {
        String[] split = typeNameString.split(DELIMITER);
        if (split.length != 2) {
            throw new IllegalArgumentException("Invalid type name string: " + typeNameString + ". Must be of format <namespace>" + DELIMITER + "<name>.");
        }
        return new TypeName(split[0], split[1]);
    }

    public TypeName(String namespace, String name) {
        this.namespace = Objects.requireNonNull(namespace);
        this.name = Objects.requireNonNull(name);
        this.canonicalTypenameString = TypeName.canonicalTypeNameString(namespace, name);
    }

    public String namespace() {
        return this.namespace;
    }

    public String name() {
        return this.name;
    }

    public String canonicalTypenameString() {
        return this.canonicalTypenameString;
    }

    public String toString() {
        return "TypeName(" + this.namespace + ", " + this.name + ")";
    }

    private static String canonicalTypeNameString(String namespace, String name) {
        return namespace + DELIMITER + name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeName typeName = (TypeName)o;
        return Objects.equals(this.namespace, typeName.namespace) && Objects.equals(this.name, typeName.name) && Objects.equals(this.canonicalTypenameString, typeName.canonicalTypenameString);
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.name, this.canonicalTypenameString);
    }
}

