/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.sdk;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.statefun.sdk.FunctionType;

public final class FunctionTypeNamespaceMatcher
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String targetNamespace;

    public static FunctionTypeNamespaceMatcher targetNamespace(String namespace) {
        return new FunctionTypeNamespaceMatcher(namespace);
    }

    private FunctionTypeNamespaceMatcher(String targetNamespace) {
        this.targetNamespace = Objects.requireNonNull(targetNamespace);
    }

    public String targetNamespace() {
        return this.targetNamespace;
    }

    public boolean matches(FunctionType functionType) {
        return this.targetNamespace.equals(functionType.namespace());
    }

    public int hashCode() {
        return this.targetNamespace.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionTypeNamespaceMatcher other = (FunctionTypeNamespaceMatcher)obj;
        return this.targetNamespace.equals(other.targetNamespace);
    }

    public String toString() {
        return String.format("FunctionTypeNamespaceMatcher(%s)", this.targetNamespace);
    }
}

