/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.sdk;

import java.io.Serializable;
import java.util.Objects;

public final class FunctionType
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String namespace;
    private final String type;

    public FunctionType(String namespace, String type) {
        this.namespace = Objects.requireNonNull(namespace);
        this.type = Objects.requireNonNull(type);
    }

    public String namespace() {
        return this.namespace;
    }

    public String name() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionType functionType = (FunctionType)o;
        return this.namespace.equals(functionType.namespace) && this.type.equals(functionType.type);
    }

    public int hashCode() {
        int hash = 0;
        hash = 37 * hash + this.namespace.hashCode();
        hash = 37 * hash + this.type.hashCode();
        return hash;
    }

    public String toString() {
        return String.format("FunctionType(%s, %s)", this.namespace, this.type);
    }
}

