/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.sdk;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.statefun.sdk.Address;
import org.apache.flink.statefun.sdk.FunctionType;
import org.apache.flink.statefun.sdk.io.EgressIdentifier;
import org.apache.flink.statefun.sdk.metrics.Metrics;

public interface Context {
    public Address self();

    public Address caller();

    public void send(Address var1, Object var2);

    public <T> void send(EgressIdentifier<T> var1, T var2);

    public void sendAfter(Duration var1, Address var2, Object var3);

    public void sendAfter(Duration var1, Address var2, Object var3, String var4);

    public void cancelDelayedMessage(String var1);

    default public void send(FunctionType functionType, String id, Object message) {
        this.send(new Address(functionType, id), message);
    }

    default public void sendAfter(Duration delay, FunctionType functionType, String id, Object message) {
        this.sendAfter(delay, new Address(functionType, id), message);
    }

    default public void reply(Object message) {
        this.send(this.caller(), message);
    }

    public <M, T> void registerAsyncOperation(M var1, CompletableFuture<T> var2);

    public Metrics metrics();
}

