/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.sdk;

import java.util.Objects;
import org.apache.flink.statefun.sdk.FunctionType;

public final class Address {
    private final FunctionType type;
    private final String id;

    public Address(FunctionType type, String id) {
        this.type = Objects.requireNonNull(type);
        this.id = Objects.requireNonNull(id);
    }

    public FunctionType type() {
        return this.type;
    }

    public String id() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address address = (Address)o;
        return this.type.equals(address.type) && this.id.equals(address.id);
    }

    public int hashCode() {
        int hash = 0;
        hash = 37 * hash + this.type.hashCode();
        hash = 37 * hash + this.id.hashCode();
        return hash;
    }

    public String toString() {
        return String.format("Address(%s, %s, %s)", this.type.namespace(), this.type.name(), this.id);
    }
}

