/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.sdk.state;

import java.util.Objects;
import org.apache.flink.statefun.sdk.TypeName;
import org.apache.flink.statefun.sdk.annotations.ForRuntime;
import org.apache.flink.statefun.sdk.state.Accessor;
import org.apache.flink.statefun.sdk.state.Expiration;

@ForRuntime
public final class RemotePersistedValue {
    private final String name;
    private final TypeName type;
    private final Expiration expiration;
    private Accessor<byte[]> accessor;

    private RemotePersistedValue(String name, TypeName type, Expiration expiration, Accessor<byte[]> accessor) {
        this.name = Objects.requireNonNull(name);
        this.type = Objects.requireNonNull(type);
        this.expiration = Objects.requireNonNull(expiration);
        this.accessor = Objects.requireNonNull(accessor);
    }

    public static RemotePersistedValue of(String stateName, TypeName typeName) {
        return new RemotePersistedValue(stateName, typeName, Expiration.none(), new NonFaultTolerantAccessor<byte[]>());
    }

    public static RemotePersistedValue of(String stateName, TypeName typeName, Expiration expiration) {
        return new RemotePersistedValue(stateName, typeName, expiration, new NonFaultTolerantAccessor<byte[]>());
    }

    public byte[] get() {
        return this.accessor.get();
    }

    public void set(byte[] value) {
        this.accessor.set(value);
    }

    public void clear() {
        this.accessor.clear();
    }

    public String name() {
        return this.name;
    }

    public TypeName type() {
        return this.type;
    }

    public Expiration expiration() {
        return this.expiration;
    }

    @ForRuntime
    void setAccessor(Accessor<byte[]> newAccessor) {
        this.accessor = Objects.requireNonNull(newAccessor);
    }

    private static final class NonFaultTolerantAccessor<E>
    implements Accessor<E> {
        private E element;

        private NonFaultTolerantAccessor() {
        }

        @Override
        public void set(E element) {
            this.element = element;
        }

        @Override
        public E get() {
            return this.element;
        }

        @Override
        public void clear() {
            this.element = null;
        }
    }
}

