/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.sdk.state;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.statefun.sdk.annotations.ForRuntime;
import org.apache.flink.statefun.sdk.state.Expiration;
import org.apache.flink.statefun.sdk.state.TableAccessor;

public final class PersistedTable<K, V> {
    private final String name;
    private final Class<K> keyType;
    private final Class<V> valueType;
    private final Expiration expiration;
    private TableAccessor<K, V> accessor;

    private PersistedTable(String name, Class<K> keyType, Class<V> valueType, Expiration expiration, TableAccessor<K, V> accessor) {
        this.name = Objects.requireNonNull(name);
        this.keyType = Objects.requireNonNull(keyType);
        this.valueType = Objects.requireNonNull(valueType);
        this.expiration = Objects.requireNonNull(expiration);
        this.accessor = Objects.requireNonNull(accessor);
    }

    public static <K, V> PersistedTable<K, V> of(String name, Class<K> keyType, Class<V> valueType) {
        return PersistedTable.of(name, keyType, valueType, Expiration.none());
    }

    public static <K, V> PersistedTable<K, V> of(String name, Class<K> keyType, Class<V> valueType, Expiration expiration) {
        return new PersistedTable<K, V>(name, keyType, valueType, expiration, new NonFaultTolerantAccessor());
    }

    public String name() {
        return this.name;
    }

    public Class<K> keyType() {
        return this.keyType;
    }

    public Class<V> valueType() {
        return this.valueType;
    }

    public Expiration expiration() {
        return this.expiration;
    }

    public V get(K key) {
        return this.accessor.get(key);
    }

    public void set(K key, V value) {
        this.accessor.set(key, value);
    }

    public void remove(K key) {
        this.accessor.remove(key);
    }

    public Iterable<Map.Entry<K, V>> entries() {
        return this.accessor.entries();
    }

    public Iterable<K> keys() {
        return this.accessor.keys();
    }

    public Iterable<V> values() {
        return this.accessor.values();
    }

    public void clear() {
        this.accessor.clear();
    }

    public String toString() {
        return String.format("PersistedTable{name=%s, keyType=%s, valueType=%s, expiration=%s}", this.name, this.keyType.getName(), this.valueType.getName(), this.expiration);
    }

    @ForRuntime
    void setAccessor(TableAccessor<K, V> newAccessor) {
        Objects.requireNonNull(newAccessor);
        this.accessor = newAccessor;
    }

    private static final class NonFaultTolerantAccessor<K, V>
    implements TableAccessor<K, V> {
        private final Map<K, V> map = new HashMap();

        private NonFaultTolerantAccessor() {
        }

        @Override
        public void set(K key, V value) {
            this.map.put(key, value);
        }

        @Override
        public V get(K key) {
            return this.map.get(key);
        }

        @Override
        public void remove(K key) {
            this.map.remove(key);
        }

        @Override
        public Iterable<Map.Entry<K, V>> entries() {
            return this.map.entrySet();
        }

        @Override
        public Iterable<K> keys() {
            return this.map.keySet();
        }

        @Override
        public Iterable<V> values() {
            return this.map.values();
        }

        @Override
        public void clear() {
            this.map.clear();
        }
    }
}

