/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.sdk.state;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.statefun.sdk.annotations.ForRuntime;
import org.apache.flink.statefun.sdk.state.PersistedAppendingBuffer;
import org.apache.flink.statefun.sdk.state.PersistedTable;
import org.apache.flink.statefun.sdk.state.PersistedValue;
import org.apache.flink.statefun.sdk.state.RemotePersistedValue;
import org.apache.flink.statefun.sdk.state.StateBinder;

public final class PersistedStateRegistry {
    private final Map<String, Object> registeredStates = new HashMap<String, Object>();
    private StateBinder stateBinder = new NonFaultTolerantStateBinder();

    public <T> void registerValue(PersistedValue<T> valueState) {
        this.acceptRegistrationOrThrowIfPresent(valueState.name(), valueState);
    }

    public <K, V> void registerTable(PersistedTable<K, V> tableState) {
        this.acceptRegistrationOrThrowIfPresent(tableState.name(), tableState);
    }

    public <E> void registerAppendingBuffer(PersistedAppendingBuffer<E> bufferState) {
        this.acceptRegistrationOrThrowIfPresent(bufferState.name(), bufferState);
    }

    @ForRuntime
    public void registerRemoteValue(RemotePersistedValue remoteValueState) {
        this.acceptRegistrationOrThrowIfPresent(remoteValueState.name(), remoteValueState);
    }

    @ForRuntime
    void bind(StateBinder stateBinder) {
        if (this.isBound()) {
            throw new IllegalStateException("This registry was already bound to state binder: " + this.stateBinder.getClass().getName() + ", attempting to rebind to state binder: " + stateBinder.getClass().getName());
        }
        this.stateBinder = Objects.requireNonNull(stateBinder);
        this.registeredStates.values().forEach(stateBinder::bind);
    }

    private boolean isBound() {
        return this.stateBinder != null && !(this.stateBinder instanceof NonFaultTolerantStateBinder);
    }

    private void acceptRegistrationOrThrowIfPresent(String stateName, Object newStateObject) {
        Object previousRegistration = this.registeredStates.get(stateName);
        if (previousRegistration != null) {
            throw new IllegalStateException(String.format("State name '%s' was registered twice; previous registered state object with the same name was a %s, attempting to register a new %s under the same name.", stateName, previousRegistration, newStateObject));
        }
        this.registeredStates.put(stateName, newStateObject);
        this.stateBinder.bind(newStateObject);
    }

    private static final class NonFaultTolerantStateBinder
    extends StateBinder {
        private NonFaultTolerantStateBinder() {
        }

        @Override
        public void bind(Object stateObject) {
        }
    }
}

