/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.sdk.state;

import java.io.Serializable;
import java.time.Duration;
import java.util.Objects;
import org.apache.flink.statefun.sdk.annotations.ForRuntime;

public final class Expiration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Mode mode;
    private final Duration duration;

    public static Expiration expireAfterWriting(Duration duration) {
        return new Expiration(Mode.AFTER_WRITE, duration);
    }

    public static Expiration expireAfterReadingOrWriting(Duration duration) {
        return new Expiration(Mode.AFTER_READ_OR_WRITE, duration);
    }

    public static Expiration expireAfter(Duration duration, Mode mode) {
        return new Expiration(mode, duration);
    }

    public static Expiration none() {
        return new Expiration(Mode.NONE, Duration.ZERO);
    }

    @ForRuntime
    public Expiration(Mode mode, Duration duration) {
        this.mode = Objects.requireNonNull(mode);
        this.duration = Objects.requireNonNull(duration);
    }

    public Mode mode() {
        return this.mode;
    }

    public Duration duration() {
        return this.duration;
    }

    public String toString() {
        return String.format("Expiration{mode=%s, duration=%s}", new Object[]{this.mode, this.duration});
    }

    public static enum Mode {
        NONE,
        AFTER_WRITE,
        AFTER_READ_OR_WRITE;

    }
}

