/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.sdk;

import java.util.Objects;
import org.apache.flink.statefun.sdk.annotations.ForRuntime;

public final class AsyncOperationResult<M, T> {
    private final M metadata;
    private final Status status;
    private final T value;
    private final Throwable throwable;

    @ForRuntime
    public AsyncOperationResult(M metadata, Status status, T value, Throwable throwable) {
        this.metadata = Objects.requireNonNull(metadata);
        this.status = Objects.requireNonNull(status);
        this.value = value;
        this.throwable = throwable;
    }

    public M metadata() {
        return this.metadata;
    }

    public Status status() {
        return this.status;
    }

    public T value() {
        if (this.status != Status.SUCCESS) {
            throw new IllegalStateException("Not a successful result, but rather " + (Object)((Object)this.status));
        }
        return this.value;
    }

    public Throwable throwable() {
        if (this.status != Status.FAILURE) {
            throw new IllegalStateException("Not a failure, but rather " + (Object)((Object)this.status));
        }
        return this.throwable;
    }

    public boolean successful() {
        return this.status == Status.SUCCESS;
    }

    public boolean unknown() {
        return this.status == Status.UNKNOWN;
    }

    public boolean failure() {
        return this.status == Status.FAILURE;
    }

    public static enum Status {
        SUCCESS,
        FAILURE,
        UNKNOWN;

    }
}

