/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.sdk.kafka;

import java.time.ZonedDateTime;
import java.util.Map;
import org.apache.flink.statefun.sdk.kafka.KafkaTopicPartition;

public class KafkaIngressStartupPosition {
    private KafkaIngressStartupPosition() {
    }

    public static KafkaIngressStartupPosition fromGroupOffsets() {
        return GroupOffsetsPosition.INSTANCE;
    }

    public static KafkaIngressStartupPosition fromEarliest() {
        return EarliestPosition.INSTANCE;
    }

    public static KafkaIngressStartupPosition fromLatest() {
        return LatestPosition.INSTANCE;
    }

    public static KafkaIngressStartupPosition fromSpecificOffsets(Map<KafkaTopicPartition, Long> specificOffsets) {
        if (specificOffsets == null || specificOffsets.isEmpty()) {
            throw new IllegalArgumentException("Provided specific offsets must not be empty.");
        }
        return new SpecificOffsetsPosition(specificOffsets);
    }

    public static KafkaIngressStartupPosition fromDate(ZonedDateTime date) {
        return new DatePosition(date);
    }

    public boolean isGroupOffsets() {
        return this.getClass() == GroupOffsetsPosition.class;
    }

    public boolean isEarliest() {
        return this.getClass() == EarliestPosition.class;
    }

    public boolean isLatest() {
        return this.getClass() == LatestPosition.class;
    }

    public boolean isSpecificOffsets() {
        return this.getClass() == SpecificOffsetsPosition.class;
    }

    public boolean isDate() {
        return this.getClass() == DatePosition.class;
    }

    public SpecificOffsetsPosition asSpecificOffsets() {
        if (!this.isSpecificOffsets()) {
            throw new IllegalStateException("This is not a startup position configured using specific offsets.");
        }
        return (SpecificOffsetsPosition)this;
    }

    public DatePosition asDate() {
        if (!this.isDate()) {
            throw new IllegalStateException("This is not a startup position configured using a Date.");
        }
        return (DatePosition)this;
    }

    public static final class DatePosition
    extends KafkaIngressStartupPosition {
        private final ZonedDateTime date;

        private DatePosition(ZonedDateTime date) {
            this.date = date;
        }

        public long epochMilli() {
            return this.date.toInstant().toEpochMilli();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof DatePosition)) {
                return false;
            }
            DatePosition that = (DatePosition)obj;
            return that.date.equals(this.date);
        }

        public int hashCode() {
            return this.date.hashCode();
        }
    }

    public static final class SpecificOffsetsPosition
    extends KafkaIngressStartupPosition {
        private final Map<KafkaTopicPartition, Long> specificOffsets;

        private SpecificOffsetsPosition(Map<KafkaTopicPartition, Long> specificOffsets) {
            this.specificOffsets = specificOffsets;
        }

        public Map<KafkaTopicPartition, Long> specificOffsets() {
            return this.specificOffsets;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SpecificOffsetsPosition)) {
                return false;
            }
            SpecificOffsetsPosition that = (SpecificOffsetsPosition)obj;
            return that.specificOffsets.equals(this.specificOffsets);
        }

        public int hashCode() {
            return this.specificOffsets.hashCode();
        }
    }

    public static final class LatestPosition
    extends KafkaIngressStartupPosition {
        private static final LatestPosition INSTANCE = new LatestPosition();

        private LatestPosition() {
        }

        public boolean equals(Object obj) {
            return obj != null && obj instanceof LatestPosition;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    public static final class EarliestPosition
    extends KafkaIngressStartupPosition {
        private static final EarliestPosition INSTANCE = new EarliestPosition();

        private EarliestPosition() {
        }

        public boolean equals(Object obj) {
            return obj != null && obj instanceof EarliestPosition;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    public static final class GroupOffsetsPosition
    extends KafkaIngressStartupPosition {
        private static final GroupOffsetsPosition INSTANCE = new GroupOffsetsPosition();

        private GroupOffsetsPosition() {
        }

        public boolean equals(Object obj) {
            return obj != null && obj instanceof GroupOffsetsPosition;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }
}

